@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.PartitionIndexArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.PartitionIndexPartitionIndexArgs
import com.pulumi.aws.glue.kotlin.inputs.PartitionIndexPartitionIndexArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import com.pulumi.aws.glue.CatalogTable;
 * import com.pulumi.aws.glue.CatalogTableArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSerDeInfoArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSkewedInfoArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTablePartitionKeyArgs;
 * import com.pulumi.aws.glue.PartitionIndex;
 * import com.pulumi.aws.glue.PartitionIndexArgs;
 * import com.pulumi.aws.glue.inputs.PartitionIndexPartitionIndexArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCatalogDatabase = new CatalogDatabase("exampleCatalogDatabase", CatalogDatabaseArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleCatalogTable = new CatalogTable("exampleCatalogTable", CatalogTableArgs.builder()
 *             .name("example")
 *             .databaseName(exampleCatalogDatabase.name())
 *             .owner("my_owner")
 *             .retention(1)
 *             .tableType("VIRTUAL_VIEW")
 *             .viewExpandedText("view_expanded_text_1")
 *             .viewOriginalText("view_original_text_1")
 *             .storageDescriptor(CatalogTableStorageDescriptorArgs.builder()
 *                 .bucketColumns("bucket_column_1")
 *                 .compressed(false)
 *                 .inputFormat("SequenceFileInputFormat")
 *                 .location("my_location")
 *                 .numberOfBuckets(1)
 *                 .outputFormat("SequenceFileInputFormat")
 *                 .storedAsSubDirectories(false)
 *                 .parameters(Map.of("param1", "param1_val"))
 *                 .columns(
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_column_1")
 *                         .type("int")
 *                         .comment("my_column1_comment")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_column_2")
 *                         .type("string")
 *                         .comment("my_column2_comment")
 *                         .build())
 *                 .serDeInfo(CatalogTableStorageDescriptorSerDeInfoArgs.builder()
 *                     .name("ser_de_name")
 *                     .parameters(Map.of("param1", "param_val_1"))
 *                     .serializationLibrary("org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe")
 *                     .build())
 *                 .sortColumns(CatalogTableStorageDescriptorSortColumnArgs.builder()
 *                     .column("my_column_1")
 *                     .sortOrder(1)
 *                     .build())
 *                 .skewedInfo(CatalogTableStorageDescriptorSkewedInfoArgs.builder()
 *                     .skewedColumnNames("my_column_1")
 *                     .skewedColumnValueLocationMaps(Map.of("my_column_1", "my_column_1_val_loc_map"))
 *                     .skewedColumnValues("skewed_val_1")
 *                     .build())
 *                 .build())
 *             .partitionKeys(
 *                 CatalogTablePartitionKeyArgs.builder()
 *                     .name("my_column_1")
 *                     .type("int")
 *                     .comment("my_column_1_comment")
 *                     .build(),
 *                 CatalogTablePartitionKeyArgs.builder()
 *                     .name("my_column_2")
 *                     .type("string")
 *                     .comment("my_column_2_comment")
 *                     .build())
 *             .parameters(Map.of("param1", "param1_val"))
 *             .build());
 *         var examplePartitionIndex = new PartitionIndex("examplePartitionIndex", PartitionIndexArgs.builder()
 *             .databaseName(exampleCatalogDatabase.name())
 *             .tableName(exampleCatalogTable.name())
 *             .partitionIndex(PartitionIndexPartitionIndexArgs.builder()
 *                 .indexName("example")
 *                 .keys(
 *                     "my_column_1",
 *                     "my_column_2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Partition Indexes using the catalog ID (usually AWS account ID), database name, table name, and index name. For example:
 * ```sh
 *  $ pulumi import aws:glue/partitionIndex:PartitionIndex example 123456789012:MyDatabase:MyTable:index-name
 * ```
 * @property catalogId The catalog ID where the table resides.
 * @property databaseName Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
 * @property partitionIndex Configuration block for a partition index. See `partition_index` below.
 * @property tableName Name of the table. For Hive compatibility, this must be entirely lowercase.
 */
public data class PartitionIndexArgs(
    public val catalogId: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val partitionIndex: Output<PartitionIndexPartitionIndexArgs>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.PartitionIndexArgs> {
    override fun toJava(): com.pulumi.aws.glue.PartitionIndexArgs =
        com.pulumi.aws.glue.PartitionIndexArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .partitionIndex(partitionIndex?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartitionIndexArgs].
 */
@PulumiTagMarker
public class PartitionIndexArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var partitionIndex: Output<PartitionIndexPartitionIndexArgs>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The catalog ID where the table resides.
     */
    @JvmName("gyxdjoulwmttgbhi")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     */
    @JvmName("ihxmubqmalglsbdy")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Configuration block for a partition index. See `partition_index` below.
     */
    @JvmName("eokurxwrpwwtmnvc")
    public suspend fun partitionIndex(`value`: Output<PartitionIndexPartitionIndexArgs>) {
        this.partitionIndex = value
    }

    /**
     * @param value Name of the table. For Hive compatibility, this must be entirely lowercase.
     */
    @JvmName("prjtistoklramadl")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The catalog ID where the table resides.
     */
    @JvmName("brjqdccryyphqbvu")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     */
    @JvmName("btdaspmjabankwcy")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Configuration block for a partition index. See `partition_index` below.
     */
    @JvmName("uamtrloemrrekhoh")
    public suspend fun partitionIndex(`value`: PartitionIndexPartitionIndexArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionIndex = mapped
    }

    /**
     * @param argument Configuration block for a partition index. See `partition_index` below.
     */
    @JvmName("rdjkxaevqenwggvw")
    public suspend
    fun partitionIndex(argument: suspend PartitionIndexPartitionIndexArgsBuilder.() -> Unit) {
        val toBeMapped = PartitionIndexPartitionIndexArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.partitionIndex = mapped
    }

    /**
     * @param value Name of the table. For Hive compatibility, this must be entirely lowercase.
     */
    @JvmName("lrwxrqwnubrmhbys")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): PartitionIndexArgs = PartitionIndexArgs(
        catalogId = catalogId,
        databaseName = databaseName,
        partitionIndex = partitionIndex,
        tableName = tableName,
    )
}
