@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.ResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Glue resource policy. Only one can exist per region.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.glue.ResourcePolicy;
 * import com.pulumi.aws.glue.ResourcePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentPartition = AwsFunctions.getPartition();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var glue-example-policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("glue:CreateTable")
 *                 .resources(String.format("arn:%s:glue:%s:%s:*", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("*")
 *                     .type("AWS")
 *                     .build())
 *                 .build())
 *             .build());
 *         var example = new ResourcePolicy("example", ResourcePolicyArgs.builder()
 *             .policy(glue_example_policy.json())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Resource Policy using the account ID. For example:
 * ```sh
 *  $ pulumi import aws:glue/resourcePolicy:ResourcePolicy Test 12356789012
 * ```
 * @property enableHybrid Indicates that you are using both methods to grant cross-account. Valid values are `TRUE` and `FALSE`. Note the provider will not perform drift detetction on this field as its not return on read.
 * @property policy The policy to be applied to the aws glue data catalog.
 */
public data class ResourcePolicyArgs(
    public val enableHybrid: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.ResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.glue.ResourcePolicyArgs =
        com.pulumi.aws.glue.ResourcePolicyArgs.builder()
            .enableHybrid(enableHybrid?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePolicyArgs].
 */
@PulumiTagMarker
public class ResourcePolicyArgsBuilder internal constructor() {
    private var enableHybrid: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value Indicates that you are using both methods to grant cross-account. Valid values are `TRUE` and `FALSE`. Note the provider will not perform drift detetction on this field as its not return on read.
     */
    @JvmName("lwsnpcxxqfhclbwg")
    public suspend fun enableHybrid(`value`: Output<String>) {
        this.enableHybrid = value
    }

    /**
     * @param value The policy to be applied to the aws glue data catalog.
     */
    @JvmName("bxvtcmkwsflbgbaf")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Indicates that you are using both methods to grant cross-account. Valid values are `TRUE` and `FALSE`. Note the provider will not perform drift detetction on this field as its not return on read.
     */
    @JvmName("aakdxthjsrbdtdxy")
    public suspend fun enableHybrid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHybrid = mapped
    }

    /**
     * @param value The policy to be applied to the aws glue data catalog.
     */
    @JvmName("stqtbvnrtjnusvvx")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): ResourcePolicyArgs = ResourcePolicyArgs(
        enableHybrid = enableHybrid,
        policy = policy,
    )
}
