@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.SchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Schema resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Schema;
 * import com.pulumi.aws.glue.SchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Schema("example", SchemaArgs.builder()
 *             .schemaName("example")
 *             .registryArn(aws_glue_registry.test().arn())
 *             .dataFormat("AVRO")
 *             .compatibility("NONE")
 *             .schemaDefinition("{\"type\": \"record\", \"name\": \"r1\", \"fields\": [ {\"name\": \"f1\", \"type\": \"int\"}, {\"name\": \"f2\", \"type\": \"string\"} ]}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Registries using `arn`. For example:
 * ```sh
 *  $ pulumi import aws:glue/schema:Schema example arn:aws:glue:us-west-2:123456789012:schema/example/example
 * ```
 * @property compatibility The compatibility mode of the schema. Values values are: `NONE`, `DISABLED`, `BACKWARD`, `BACKWARD_ALL`, `FORWARD`, `FORWARD_ALL`, `FULL`, and `FULL_ALL`.
 * @property dataFormat The data format of the schema definition. Valid values are `AVRO`, `JSON` and `PROTOBUF`.
 * @property description A description of the schema.
 * @property registryArn The ARN of the Glue Registry to create the schema in.
 * @property schemaDefinition The schema definition using the `data_format` setting for `schema_name`.
 * @property schemaName The Name of the schema.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SchemaArgs(
    public val compatibility: Output<String>? = null,
    public val dataFormat: Output<String>? = null,
    public val description: Output<String>? = null,
    public val registryArn: Output<String>? = null,
    public val schemaDefinition: Output<String>? = null,
    public val schemaName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.SchemaArgs> {
    override fun toJava(): com.pulumi.aws.glue.SchemaArgs = com.pulumi.aws.glue.SchemaArgs.builder()
        .compatibility(compatibility?.applyValue({ args0 -> args0 }))
        .dataFormat(dataFormat?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .registryArn(registryArn?.applyValue({ args0 -> args0 }))
        .schemaDefinition(schemaDefinition?.applyValue({ args0 -> args0 }))
        .schemaName(schemaName?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [SchemaArgs].
 */
@PulumiTagMarker
public class SchemaArgsBuilder internal constructor() {
    private var compatibility: Output<String>? = null

    private var dataFormat: Output<String>? = null

    private var description: Output<String>? = null

    private var registryArn: Output<String>? = null

    private var schemaDefinition: Output<String>? = null

    private var schemaName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The compatibility mode of the schema. Values values are: `NONE`, `DISABLED`, `BACKWARD`, `BACKWARD_ALL`, `FORWARD`, `FORWARD_ALL`, `FULL`, and `FULL_ALL`.
     */
    @JvmName("pouaiyfmqynonenv")
    public suspend fun compatibility(`value`: Output<String>) {
        this.compatibility = value
    }

    /**
     * @param value The data format of the schema definition. Valid values are `AVRO`, `JSON` and `PROTOBUF`.
     */
    @JvmName("jljwvqfdwqxrsxqj")
    public suspend fun dataFormat(`value`: Output<String>) {
        this.dataFormat = value
    }

    /**
     * @param value A description of the schema.
     */
    @JvmName("sxywcmtpujcnyjgq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ARN of the Glue Registry to create the schema in.
     */
    @JvmName("oxooqimvymshmgdb")
    public suspend fun registryArn(`value`: Output<String>) {
        this.registryArn = value
    }

    /**
     * @param value The schema definition using the `data_format` setting for `schema_name`.
     */
    @JvmName("fjmbeddwvuxeamjn")
    public suspend fun schemaDefinition(`value`: Output<String>) {
        this.schemaDefinition = value
    }

    /**
     * @param value The Name of the schema.
     */
    @JvmName("tgfglydotsksmrfi")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vuotlomiulosynsm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The compatibility mode of the schema. Values values are: `NONE`, `DISABLED`, `BACKWARD`, `BACKWARD_ALL`, `FORWARD`, `FORWARD_ALL`, `FULL`, and `FULL_ALL`.
     */
    @JvmName("etbeihooolngucnk")
    public suspend fun compatibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compatibility = mapped
    }

    /**
     * @param value The data format of the schema definition. Valid values are `AVRO`, `JSON` and `PROTOBUF`.
     */
    @JvmName("eerxmeovrqqqloxy")
    public suspend fun dataFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value A description of the schema.
     */
    @JvmName("klpyqceaordtxwas")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ARN of the Glue Registry to create the schema in.
     */
    @JvmName("dgjfkmpcubgqgcph")
    public suspend fun registryArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryArn = mapped
    }

    /**
     * @param value The schema definition using the `data_format` setting for `schema_name`.
     */
    @JvmName("cgdeinxjxpkbviah")
    public suspend fun schemaDefinition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaDefinition = mapped
    }

    /**
     * @param value The Name of the schema.
     */
    @JvmName("blxiieovnuxiwfpl")
    public suspend fun schemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("offfirsragklomqe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pvxkdgteatjunoek")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SchemaArgs = SchemaArgs(
        compatibility = compatibility,
        dataFormat = dataFormat,
        description = description,
        registryArn = registryArn,
        schemaDefinition = schemaDefinition,
        schemaName = schemaName,
        tags = tags,
    )
}
