@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.SecurityConfigurationArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.SecurityConfigurationEncryptionConfigurationArgs
import com.pulumi.aws.glue.kotlin.inputs.SecurityConfigurationEncryptionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages a Glue Security Configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.SecurityConfiguration;
 * import com.pulumi.aws.glue.SecurityConfigurationArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityConfiguration("example", SecurityConfigurationArgs.builder()
 *             .encryptionConfiguration(SecurityConfigurationEncryptionConfigurationArgs.builder()
 *                 .cloudwatchEncryption(SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs.builder()
 *                     .cloudwatchEncryptionMode("DISABLED")
 *                     .build())
 *                 .jobBookmarksEncryption(SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs.builder()
 *                     .jobBookmarksEncryptionMode("DISABLED")
 *                     .build())
 *                 .s3Encryption(SecurityConfigurationEncryptionConfigurationS3EncryptionArgs.builder()
 *                     .kmsKeyArn(data.aws_kms_key().example().arn())
 *                     .s3EncryptionMode("SSE-KMS")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Security Configurations using `name`. For example:
 * ```sh
 *  $ pulumi import aws:glue/securityConfiguration:SecurityConfiguration example example
 * ```
 * @property encryptionConfiguration Configuration block containing encryption configuration. Detailed below.
 * @property name Name of the security configuration.
 */
public data class SecurityConfigurationArgs(
    public val encryptionConfiguration: Output<SecurityConfigurationEncryptionConfigurationArgs>? =
        null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.SecurityConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.glue.SecurityConfigurationArgs =
        com.pulumi.aws.glue.SecurityConfigurationArgs.builder()
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityConfigurationArgs].
 */
@PulumiTagMarker
public class SecurityConfigurationArgsBuilder internal constructor() {
    private var encryptionConfiguration: Output<SecurityConfigurationEncryptionConfigurationArgs>? =
        null

    private var name: Output<String>? = null

    /**
     * @param value Configuration block containing encryption configuration. Detailed below.
     */
    @JvmName("lcquoitfxibbxrwr")
    public suspend
    fun encryptionConfiguration(`value`: Output<SecurityConfigurationEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value Name of the security configuration.
     */
    @JvmName("rwgxpwggqbcdvyjm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block containing encryption configuration. Detailed below.
     */
    @JvmName("pgeeikvwkhskqpcq")
    public suspend
    fun encryptionConfiguration(`value`: SecurityConfigurationEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument Configuration block containing encryption configuration. Detailed below.
     */
    @JvmName("uqrwyoueipmqrcbo")
    public suspend
    fun encryptionConfiguration(argument: suspend SecurityConfigurationEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityConfigurationEncryptionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value Name of the security configuration.
     */
    @JvmName("dxnyblxbgqnrvsgi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SecurityConfigurationArgs = SecurityConfigurationArgs(
        encryptionConfiguration = encryptionConfiguration,
        name = name,
    )
}
