@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.TriggerAction
import com.pulumi.aws.glue.kotlin.outputs.TriggerEventBatchingCondition
import com.pulumi.aws.glue.kotlin.outputs.TriggerPredicate
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.glue.kotlin.outputs.TriggerAction.Companion.toKotlin as triggerActionToKotlin
import com.pulumi.aws.glue.kotlin.outputs.TriggerEventBatchingCondition.Companion.toKotlin as triggerEventBatchingConditionToKotlin
import com.pulumi.aws.glue.kotlin.outputs.TriggerPredicate.Companion.toKotlin as triggerPredicateToKotlin

/**
 * Builder for [Trigger].
 */
@PulumiTagMarker
public class TriggerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TriggerArgs = TriggerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TriggerArgsBuilder.() -> Unit) {
        val builder = TriggerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Trigger {
        val builtJavaResource = com.pulumi.aws.glue.Trigger(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Trigger(builtJavaResource)
    }
}

/**
 * Manages a Glue Trigger resource.
 * ## Example Usage
 * ### Conditional Trigger
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import com.pulumi.aws.glue.inputs.TriggerPredicateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trigger("example", TriggerArgs.builder()
 *             .type("CONDITIONAL")
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName(aws_glue_job.example1().name())
 *                 .build())
 *             .predicate(TriggerPredicateArgs.builder()
 *                 .conditions(TriggerPredicateConditionArgs.builder()
 *                     .jobName(aws_glue_job.example2().name())
 *                     .state("SUCCEEDED")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### On-Demand Trigger
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trigger("example", TriggerArgs.builder()
 *             .type("ON_DEMAND")
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName(aws_glue_job.example().name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Scheduled Trigger
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trigger("example", TriggerArgs.builder()
 *             .schedule("cron(15 12 * * ? *)")
 *             .type("SCHEDULED")
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName(aws_glue_job.example().name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Conditional Trigger with Crawler Action
 * **Note:** Triggers can have both a crawler action and a crawler condition, just no example provided.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import com.pulumi.aws.glue.inputs.TriggerPredicateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trigger("example", TriggerArgs.builder()
 *             .type("CONDITIONAL")
 *             .actions(TriggerActionArgs.builder()
 *                 .crawlerName(aws_glue_crawler.example1().name())
 *                 .build())
 *             .predicate(TriggerPredicateArgs.builder()
 *                 .conditions(TriggerPredicateConditionArgs.builder()
 *                     .jobName(aws_glue_job.example2().name())
 *                     .state("SUCCEEDED")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Conditional Trigger with Crawler Condition
 * **Note:** Triggers can have both a crawler action and a crawler condition, just no example provided.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import com.pulumi.aws.glue.inputs.TriggerPredicateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trigger("example", TriggerArgs.builder()
 *             .type("CONDITIONAL")
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName(aws_glue_job.example1().name())
 *                 .build())
 *             .predicate(TriggerPredicateArgs.builder()
 *                 .conditions(TriggerPredicateConditionArgs.builder()
 *                     .crawlerName(aws_glue_crawler.example2().name())
 *                     .crawlState("SUCCEEDED")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Triggers using `name`. For example:
 * ```sh
 *  $ pulumi import aws:glue/trigger:Trigger MyTrigger MyTrigger
 * ```
 *
 */
public class Trigger internal constructor(
    override val javaResource: com.pulumi.aws.glue.Trigger,
) : KotlinCustomResource(javaResource, TriggerMapper) {
    /**
     * List of actions initiated by this trigger when it fires. See Actions Below.
     */
    public val actions: Output<List<TriggerAction>>
        get() = javaResource.actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    triggerActionToKotlin(args0)
                })
            })
        })

    /**
     * Amazon Resource Name (ARN) of Glue Trigger
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description of the new trigger.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Start the trigger. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires. See Event Batching Condition.
     */
    public val eventBatchingConditions: Output<List<TriggerEventBatchingCondition>>?
        get() = javaResource.eventBatchingConditions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        triggerEventBatchingConditionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the trigger.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A predicate to specify when the new trigger should fire. Required when trigger type is `CONDITIONAL`. See Predicate Below.
     */
    public val predicate: Output<TriggerPredicate>?
        get() = javaResource.predicate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    triggerPredicateToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A cron expression used to specify the schedule. [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html)
     */
    public val schedule: Output<String>?
        get() = javaResource.schedule().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Set to true to start `SCHEDULED` and `CONDITIONAL` triggers when created. True is not supported for `ON_DEMAND` triggers.
     */
    public val startOnCreation: Output<Boolean>?
        get() = javaResource.startOnCreation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The condition job state. Currently, the values supported are `SUCCEEDED`, `STOPPED`, `TIMEOUT` and `FAILED`. If this is specified, `job_name` must also be specified. Conflicts with `crawler_state`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of trigger. Valid values are `CONDITIONAL`, `EVENT`, `ON_DEMAND`, and `SCHEDULED`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A workflow to which the trigger should be associated to. Every workflow graph (DAG) needs a starting trigger (`ON_DEMAND` or `SCHEDULED` type) and can contain multiple additional `CONDITIONAL` triggers.
     */
    public val workflowName: Output<String>?
        get() = javaResource.workflowName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object TriggerMapper : ResourceMapper<Trigger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.Trigger::class == javaResource::class

    override fun map(javaResource: Resource): Trigger = Trigger(
        javaResource as
            com.pulumi.aws.glue.Trigger,
    )
}

/**
 * @see [Trigger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Trigger].
 */
public suspend fun trigger(name: String, block: suspend TriggerResourceBuilder.() -> Unit):
    Trigger {
    val builder = TriggerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Trigger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trigger(name: String): Trigger {
    val builder = TriggerResourceBuilder()
    builder.name(name)
    return builder.build()
}
