@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.UserDefinedFunctionResourceUri
import com.pulumi.aws.glue.kotlin.outputs.UserDefinedFunctionResourceUri.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [UserDefinedFunction].
 */
@PulumiTagMarker
public class UserDefinedFunctionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserDefinedFunctionArgs = UserDefinedFunctionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserDefinedFunctionArgsBuilder.() -> Unit) {
        val builder = UserDefinedFunctionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserDefinedFunction {
        val builtJavaResource = com.pulumi.aws.glue.UserDefinedFunction(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserDefinedFunction(builtJavaResource)
    }
}

/**
 * Provides a Glue User Defined Function Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import com.pulumi.aws.glue.UserDefinedFunction;
 * import com.pulumi.aws.glue.UserDefinedFunctionArgs;
 * import com.pulumi.aws.glue.inputs.UserDefinedFunctionResourceUriArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCatalogDatabase = new CatalogDatabase("exampleCatalogDatabase", CatalogDatabaseArgs.builder()
 *             .name("my_database")
 *             .build());
 *         var exampleUserDefinedFunction = new UserDefinedFunction("exampleUserDefinedFunction", UserDefinedFunctionArgs.builder()
 *             .catalogId(exampleCatalogDatabase.catalogId())
 *             .databaseName(exampleCatalogDatabase.name())
 *             .className("class")
 *             .ownerName("owner")
 *             .ownerType("GROUP")
 *             .resourceUris(UserDefinedFunctionResourceUriArgs.builder()
 *                 .resourceType("ARCHIVE")
 *                 .uri("uri")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue User Defined Functions using the `catalog_id:database_name:function_name`. If you have not set a Catalog ID specify the AWS Account ID that the database is in. For example:
 * ```sh
 *  $ pulumi import aws:glue/userDefinedFunction:UserDefinedFunction func 123456789012:my_database:my_func
 * ```
 *
 */
public class UserDefinedFunction internal constructor(
    override val javaResource: com.pulumi.aws.glue.UserDefinedFunction,
) : KotlinCustomResource(javaResource, UserDefinedFunctionMapper) {
    /**
     * The ARN of the Glue User Defined Function.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ID of the Glue Catalog to create the function in. If omitted, this defaults to the AWS Account ID.
     */
    public val catalogId: Output<String>?
        get() = javaResource.catalogId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Java class that contains the function code.
     */
    public val className: Output<String>
        get() = javaResource.className().applyValue({ args0 -> args0 })

    /**
     * The time at which the function was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The name of the Database to create the Function.
     */
    public val databaseName: Output<String>
        get() = javaResource.databaseName().applyValue({ args0 -> args0 })

    /**
     * The name of the function.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The owner of the function.
     */
    public val ownerName: Output<String>
        get() = javaResource.ownerName().applyValue({ args0 -> args0 })

    /**
     * The owner type. can be one of `USER`, `ROLE`, and `GROUP`.
     */
    public val ownerType: Output<String>
        get() = javaResource.ownerType().applyValue({ args0 -> args0 })

    /**
     * The configuration block for Resource URIs. See resource uris below for more details.
     */
    public val resourceUris: Output<List<UserDefinedFunctionResourceUri>>?
        get() = javaResource.resourceUris().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object UserDefinedFunctionMapper : ResourceMapper<UserDefinedFunction> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.UserDefinedFunction::class == javaResource::class

    override fun map(javaResource: Resource): UserDefinedFunction = UserDefinedFunction(
        javaResource
            as com.pulumi.aws.glue.UserDefinedFunction,
    )
}

/**
 * @see [UserDefinedFunction].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserDefinedFunction].
 */
public suspend fun userDefinedFunction(
    name: String,
    block: suspend UserDefinedFunctionResourceBuilder.() -> Unit,
): UserDefinedFunction {
    val builder = UserDefinedFunctionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserDefinedFunction].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userDefinedFunction(name: String): UserDefinedFunction {
    val builder = UserDefinedFunctionResourceBuilder()
    builder.name(name)
    return builder.build()
}
