@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.UserDefinedFunctionArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.UserDefinedFunctionResourceUriArgs
import com.pulumi.aws.glue.kotlin.inputs.UserDefinedFunctionResourceUriArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Glue User Defined Function Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import com.pulumi.aws.glue.UserDefinedFunction;
 * import com.pulumi.aws.glue.UserDefinedFunctionArgs;
 * import com.pulumi.aws.glue.inputs.UserDefinedFunctionResourceUriArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCatalogDatabase = new CatalogDatabase("exampleCatalogDatabase", CatalogDatabaseArgs.builder()
 *             .name("my_database")
 *             .build());
 *         var exampleUserDefinedFunction = new UserDefinedFunction("exampleUserDefinedFunction", UserDefinedFunctionArgs.builder()
 *             .catalogId(exampleCatalogDatabase.catalogId())
 *             .databaseName(exampleCatalogDatabase.name())
 *             .className("class")
 *             .ownerName("owner")
 *             .ownerType("GROUP")
 *             .resourceUris(UserDefinedFunctionResourceUriArgs.builder()
 *                 .resourceType("ARCHIVE")
 *                 .uri("uri")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue User Defined Functions using the `catalog_id:database_name:function_name`. If you have not set a Catalog ID specify the AWS Account ID that the database is in. For example:
 * ```sh
 *  $ pulumi import aws:glue/userDefinedFunction:UserDefinedFunction func 123456789012:my_database:my_func
 * ```
 * @property catalogId ID of the Glue Catalog to create the function in. If omitted, this defaults to the AWS Account ID.
 * @property className The Java class that contains the function code.
 * @property databaseName The name of the Database to create the Function.
 * @property name The name of the function.
 * @property ownerName The owner of the function.
 * @property ownerType The owner type. can be one of `USER`, `ROLE`, and `GROUP`.
 * @property resourceUris The configuration block for Resource URIs. See resource uris below for more details.
 */
public data class UserDefinedFunctionArgs(
    public val catalogId: Output<String>? = null,
    public val className: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ownerName: Output<String>? = null,
    public val ownerType: Output<String>? = null,
    public val resourceUris: Output<List<UserDefinedFunctionResourceUriArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.UserDefinedFunctionArgs> {
    override fun toJava(): com.pulumi.aws.glue.UserDefinedFunctionArgs =
        com.pulumi.aws.glue.UserDefinedFunctionArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .className(className?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ownerName(ownerName?.applyValue({ args0 -> args0 }))
            .ownerType(ownerType?.applyValue({ args0 -> args0 }))
            .resourceUris(
                resourceUris?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [UserDefinedFunctionArgs].
 */
@PulumiTagMarker
public class UserDefinedFunctionArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var className: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var name: Output<String>? = null

    private var ownerName: Output<String>? = null

    private var ownerType: Output<String>? = null

    private var resourceUris: Output<List<UserDefinedFunctionResourceUriArgs>>? = null

    /**
     * @param value ID of the Glue Catalog to create the function in. If omitted, this defaults to the AWS Account ID.
     */
    @JvmName("qnkbhktfvbcyejwe")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value The Java class that contains the function code.
     */
    @JvmName("ssqsklngjmsvbxdu")
    public suspend fun className(`value`: Output<String>) {
        this.className = value
    }

    /**
     * @param value The name of the Database to create the Function.
     */
    @JvmName("qoekhsfuwwqnlkvy")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the function.
     */
    @JvmName("ukguuuvhwveqaqop")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The owner of the function.
     */
    @JvmName("llkikpeeawtkjvre")
    public suspend fun ownerName(`value`: Output<String>) {
        this.ownerName = value
    }

    /**
     * @param value The owner type. can be one of `USER`, `ROLE`, and `GROUP`.
     */
    @JvmName("lngcrjykgjbbicde")
    public suspend fun ownerType(`value`: Output<String>) {
        this.ownerType = value
    }

    /**
     * @param value The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("ijqnrmsnroajhmwu")
    public suspend fun resourceUris(`value`: Output<List<UserDefinedFunctionResourceUriArgs>>) {
        this.resourceUris = value
    }

    @JvmName("drwfrthwdhcvrupa")
    public suspend fun resourceUris(vararg values: Output<UserDefinedFunctionResourceUriArgs>) {
        this.resourceUris = Output.all(values.asList())
    }

    /**
     * @param values The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("iggdjkadkiufqpgk")
    public suspend fun resourceUris(values: List<Output<UserDefinedFunctionResourceUriArgs>>) {
        this.resourceUris = Output.all(values)
    }

    /**
     * @param value ID of the Glue Catalog to create the function in. If omitted, this defaults to the AWS Account ID.
     */
    @JvmName("pamrkyxeskwwegou")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value The Java class that contains the function code.
     */
    @JvmName("ghtgtwkafyqfhrhh")
    public suspend fun className(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.className = mapped
    }

    /**
     * @param value The name of the Database to create the Function.
     */
    @JvmName("eryhybmcibjiylth")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the function.
     */
    @JvmName("ibscomgvsidexkyp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The owner of the function.
     */
    @JvmName("vwumdkwqdvrwysqo")
    public suspend fun ownerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerName = mapped
    }

    /**
     * @param value The owner type. can be one of `USER`, `ROLE`, and `GROUP`.
     */
    @JvmName("vqptxsuyxdauyerx")
    public suspend fun ownerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerType = mapped
    }

    /**
     * @param value The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("bnkecvwtkgcuuukw")
    public suspend fun resourceUris(`value`: List<UserDefinedFunctionResourceUriArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUris = mapped
    }

    /**
     * @param argument The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("ixhvgjnnnrlqrfbh")
    public suspend
    fun resourceUris(argument: List<suspend UserDefinedFunctionResourceUriArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserDefinedFunctionResourceUriArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceUris = mapped
    }

    /**
     * @param argument The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("xymtxmedcqosoyxf")
    public suspend fun resourceUris(
        vararg
        argument: suspend UserDefinedFunctionResourceUriArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            UserDefinedFunctionResourceUriArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceUris = mapped
    }

    /**
     * @param argument The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("vhxlxamgcqoowgbm")
    public suspend
    fun resourceUris(argument: suspend UserDefinedFunctionResourceUriArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            UserDefinedFunctionResourceUriArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceUris = mapped
    }

    /**
     * @param values The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("gbixpflqagnqdjrl")
    public suspend fun resourceUris(vararg values: UserDefinedFunctionResourceUriArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceUris = mapped
    }

    internal fun build(): UserDefinedFunctionArgs = UserDefinedFunctionArgs(
        catalogId = catalogId,
        className = className,
        databaseName = databaseName,
        name = name,
        ownerName = ownerName,
        ownerType = ownerType,
        resourceUris = resourceUris,
    )
}
