@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Workflow].
 */
@PulumiTagMarker
public class WorkflowResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkflowArgs = WorkflowArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkflowArgsBuilder.() -> Unit) {
        val builder = WorkflowArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workflow {
        val builtJavaResource = com.pulumi.aws.glue.Workflow(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workflow(builtJavaResource)
    }
}

/**
 * Provides a Glue Workflow resource.
 * The workflow graph (DAG) can be build using the `aws.glue.Trigger` resource.
 * See the example below for creating a graph with four nodes (two triggers and two jobs).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Workflow;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import com.pulumi.aws.glue.inputs.TriggerPredicateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workflow("example");
 *         var example_start = new Trigger("example-start", TriggerArgs.builder()
 *             .type("ON_DEMAND")
 *             .workflowName(example.name())
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName("example-job")
 *                 .build())
 *             .build());
 *         var example_inner = new Trigger("example-inner", TriggerArgs.builder()
 *             .type("CONDITIONAL")
 *             .workflowName(example.name())
 *             .predicate(TriggerPredicateArgs.builder()
 *                 .conditions(TriggerPredicateConditionArgs.builder()
 *                     .jobName("example-job")
 *                     .state("SUCCEEDED")
 *                     .build())
 *                 .build())
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName("another-example-job")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Workflows using `name`. For example:
 * ```sh
 *  $ pulumi import aws:glue/workflow:Workflow MyWorkflow MyWorkflow
 * ```
 *
 */
public class Workflow internal constructor(
    override val javaResource: com.pulumi.aws.glue.Workflow,
) : KotlinCustomResource(javaResource, WorkflowMapper) {
    /**
     * Amazon Resource Name (ARN) of Glue Workflow
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A map of default run properties for this workflow. These properties are passed to all jobs associated to the workflow.
     */
    public val defaultRunProperties: Output<Map<String, String>>?
        get() = javaResource.defaultRunProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Description of the workflow.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Prevents exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.
     */
    public val maxConcurrentRuns: Output<Int>?
        get() = javaResource.maxConcurrentRuns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name you assign to this workflow.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object WorkflowMapper : ResourceMapper<Workflow> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.Workflow::class == javaResource::class

    override fun map(javaResource: Resource): Workflow = Workflow(
        javaResource as
            com.pulumi.aws.glue.Workflow,
    )
}

/**
 * @see [Workflow].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workflow].
 */
public suspend fun workflow(name: String, block: suspend WorkflowResourceBuilder.() -> Unit):
    Workflow {
    val builder = WorkflowResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workflow].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workflow(name: String): Workflow {
    val builder = WorkflowResourceBuilder()
    builder.name(name)
    return builder.build()
}
