@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.WorkflowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Workflow resource.
 * The workflow graph (DAG) can be build using the `aws.glue.Trigger` resource.
 * See the example below for creating a graph with four nodes (two triggers and two jobs).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Workflow;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import com.pulumi.aws.glue.inputs.TriggerPredicateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workflow("example");
 *         var example_start = new Trigger("example-start", TriggerArgs.builder()
 *             .type("ON_DEMAND")
 *             .workflowName(example.name())
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName("example-job")
 *                 .build())
 *             .build());
 *         var example_inner = new Trigger("example-inner", TriggerArgs.builder()
 *             .type("CONDITIONAL")
 *             .workflowName(example.name())
 *             .predicate(TriggerPredicateArgs.builder()
 *                 .conditions(TriggerPredicateConditionArgs.builder()
 *                     .jobName("example-job")
 *                     .state("SUCCEEDED")
 *                     .build())
 *                 .build())
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName("another-example-job")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Workflows using `name`. For example:
 * ```sh
 *  $ pulumi import aws:glue/workflow:Workflow MyWorkflow MyWorkflow
 * ```
 * @property defaultRunProperties A map of default run properties for this workflow. These properties are passed to all jobs associated to the workflow.
 * @property description Description of the workflow.
 * @property maxConcurrentRuns Prevents exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.
 * @property name The name you assign to this workflow.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class WorkflowArgs(
    public val defaultRunProperties: Output<Map<String, String>>? = null,
    public val description: Output<String>? = null,
    public val maxConcurrentRuns: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.WorkflowArgs> {
    override fun toJava(): com.pulumi.aws.glue.WorkflowArgs =
        com.pulumi.aws.glue.WorkflowArgs.builder()
            .defaultRunProperties(
                defaultRunProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .maxConcurrentRuns(maxConcurrentRuns?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [WorkflowArgs].
 */
@PulumiTagMarker
public class WorkflowArgsBuilder internal constructor() {
    private var defaultRunProperties: Output<Map<String, String>>? = null

    private var description: Output<String>? = null

    private var maxConcurrentRuns: Output<Int>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A map of default run properties for this workflow. These properties are passed to all jobs associated to the workflow.
     */
    @JvmName("yyvykltibdhrdddh")
    public suspend fun defaultRunProperties(`value`: Output<Map<String, String>>) {
        this.defaultRunProperties = value
    }

    /**
     * @param value Description of the workflow.
     */
    @JvmName("xudvlowcdxxginmd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Prevents exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.
     */
    @JvmName("qmbtrfhbcyqfuhnp")
    public suspend fun maxConcurrentRuns(`value`: Output<Int>) {
        this.maxConcurrentRuns = value
    }

    /**
     * @param value The name you assign to this workflow.
     */
    @JvmName("evmgmioqjysodisn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ccvtleodmmesjbqb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A map of default run properties for this workflow. These properties are passed to all jobs associated to the workflow.
     */
    @JvmName("vqkansgofviuaxcq")
    public suspend fun defaultRunProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRunProperties = mapped
    }

    /**
     * @param values A map of default run properties for this workflow. These properties are passed to all jobs associated to the workflow.
     */
    @JvmName("uandgdmjekfwomqa")
    public fun defaultRunProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultRunProperties = mapped
    }

    /**
     * @param value Description of the workflow.
     */
    @JvmName("fiyswabbifwhitrl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Prevents exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.
     */
    @JvmName("rmsuyixcxrtmiupv")
    public suspend fun maxConcurrentRuns(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentRuns = mapped
    }

    /**
     * @param value The name you assign to this workflow.
     */
    @JvmName("fxqcrhbimqjkiinl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("krxwajliyshyrgjv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cfxtqvbhoshqoaid")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WorkflowArgs = WorkflowArgs(
        defaultRunProperties = defaultRunProperties,
        description = description,
        maxConcurrentRuns = maxConcurrentRuns,
        name = name,
        tags = tags,
    )
}
