@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTableOpenTableFormatInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property icebergInput Configuration block for iceberg table config. See `iceberg_input` below.
 */
public data class CatalogTableOpenTableFormatInputArgs(
    public val icebergInput: Output<CatalogTableOpenTableFormatInputIcebergInputArgs>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTableOpenTableFormatInputArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTableOpenTableFormatInputArgs =
        com.pulumi.aws.glue.inputs.CatalogTableOpenTableFormatInputArgs.builder()
            .icebergInput(icebergInput.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CatalogTableOpenTableFormatInputArgs].
 */
@PulumiTagMarker
public class CatalogTableOpenTableFormatInputArgsBuilder internal constructor() {
    private var icebergInput: Output<CatalogTableOpenTableFormatInputIcebergInputArgs>? = null

    /**
     * @param value Configuration block for iceberg table config. See `iceberg_input` below.
     */
    @JvmName("rkfpjlxqvixdkuoq")
    public suspend
    fun icebergInput(`value`: Output<CatalogTableOpenTableFormatInputIcebergInputArgs>) {
        this.icebergInput = value
    }

    /**
     * @param value Configuration block for iceberg table config. See `iceberg_input` below.
     */
    @JvmName("uylycpyipdcitylf")
    public suspend fun icebergInput(`value`: CatalogTableOpenTableFormatInputIcebergInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.icebergInput = mapped
    }

    /**
     * @param argument Configuration block for iceberg table config. See `iceberg_input` below.
     */
    @JvmName("dljcedpgquignpgx")
    public suspend
    fun icebergInput(argument: suspend CatalogTableOpenTableFormatInputIcebergInputArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogTableOpenTableFormatInputIcebergInputArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.icebergInput = mapped
    }

    internal fun build(): CatalogTableOpenTableFormatInputArgs = CatalogTableOpenTableFormatInputArgs(
        icebergInput = icebergInput ?: throw PulumiNullFieldException("icebergInput"),
    )
}
