@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTableOpenTableFormatInputIcebergInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metadataOperation A required metadata operation. Can only be set to CREATE.
 * @property version The table version for the Iceberg table. Defaults to 2.
 */
public data class CatalogTableOpenTableFormatInputIcebergInputArgs(
    public val metadataOperation: Output<String>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTableOpenTableFormatInputIcebergInputArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTableOpenTableFormatInputIcebergInputArgs =
        com.pulumi.aws.glue.inputs.CatalogTableOpenTableFormatInputIcebergInputArgs.builder()
            .metadataOperation(metadataOperation.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogTableOpenTableFormatInputIcebergInputArgs].
 */
@PulumiTagMarker
public class CatalogTableOpenTableFormatInputIcebergInputArgsBuilder internal constructor() {
    private var metadataOperation: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value A required metadata operation. Can only be set to CREATE.
     */
    @JvmName("mgbrlwycagjyqjay")
    public suspend fun metadataOperation(`value`: Output<String>) {
        this.metadataOperation = value
    }

    /**
     * @param value The table version for the Iceberg table. Defaults to 2.
     */
    @JvmName("rwelmfssfnavavpy")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value A required metadata operation. Can only be set to CREATE.
     */
    @JvmName("tbhqamyuksmpekgv")
    public suspend fun metadataOperation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadataOperation = mapped
    }

    /**
     * @param value The table version for the Iceberg table. Defaults to 2.
     */
    @JvmName("iphhordhxlthdvbw")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): CatalogTableOpenTableFormatInputIcebergInputArgs =
        CatalogTableOpenTableFormatInputIcebergInputArgs(
            metadataOperation = metadataOperation ?: throw PulumiNullFieldException("metadataOperation"),
            version = version,
        )
}
