@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTablePartitionKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comment Free-form text comment.
 * @property name Name of the Partition Key.
 * @property type Datatype of data in the Partition Key.
 */
public data class CatalogTablePartitionKeyArgs(
    public val comment: Output<String>? = null,
    public val name: Output<String>,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTablePartitionKeyArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTablePartitionKeyArgs =
        com.pulumi.aws.glue.inputs.CatalogTablePartitionKeyArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogTablePartitionKeyArgs].
 */
@PulumiTagMarker
public class CatalogTablePartitionKeyArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Free-form text comment.
     */
    @JvmName("fgkokjymrvmabmji")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Name of the Partition Key.
     */
    @JvmName("ikbhkpfvfhfrdwgo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Datatype of data in the Partition Key.
     */
    @JvmName("ebtgpneaunyvoppt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Free-form text comment.
     */
    @JvmName("ilcjsfdhqjhcqbwp")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Name of the Partition Key.
     */
    @JvmName("hrndiopyrkqgubrs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Datatype of data in the Partition Key.
     */
    @JvmName("hdfgvayftmmtfqct")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CatalogTablePartitionKeyArgs = CatalogTablePartitionKeyArgs(
        comment = comment,
        name = name ?: throw PulumiNullFieldException("name"),
        type = type,
    )
}
