@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property comment Free-form text comment.
 * @property name Name of the Column.
 * @property parameters Key-value pairs defining properties associated with the column.
 * @property type Datatype of data in the Column.
 */
public data class CatalogTableStorageDescriptorColumnArgs(
    public val comment: Output<String>? = null,
    public val name: Output<String>,
    public val parameters: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorColumnArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorColumnArgs =
        com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorColumnArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogTableStorageDescriptorColumnArgs].
 */
@PulumiTagMarker
public class CatalogTableStorageDescriptorColumnArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Free-form text comment.
     */
    @JvmName("dlrediqnkbisfpqd")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Name of the Column.
     */
    @JvmName("sjahysswpxpklirt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value pairs defining properties associated with the column.
     */
    @JvmName("knxrepgaevitwaat")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Datatype of data in the Column.
     */
    @JvmName("amiuiqpatwsintvw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Free-form text comment.
     */
    @JvmName("bfumrcjfebvghiyi")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Name of the Column.
     */
    @JvmName("fepqmtdsnbtdunne")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value pairs defining properties associated with the column.
     */
    @JvmName("bbnnymddtuaimivi")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Key-value pairs defining properties associated with the column.
     */
    @JvmName("mwisbughyvjlaojg")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Datatype of data in the Column.
     */
    @JvmName("qyrgqkwkhrwtybap")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CatalogTableStorageDescriptorColumnArgs =
        CatalogTableStorageDescriptorColumnArgs(
            comment = comment,
            name = name ?: throw PulumiNullFieldException("name"),
            parameters = parameters,
            type = type,
        )
}
