@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSchemaReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property schemaId Configuration block that contains schema identity fields. Either this or the `schema_version_id` has to be provided. See `schema_id` below.
 * @property schemaVersionId Unique ID assigned to a version of the schema. Either this or the `schema_id` has to be provided.
 * @property schemaVersionNumber Version number of the schema.
 */
public data class CatalogTableStorageDescriptorSchemaReferenceArgs(
    public val schemaId: Output<CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs>? = null,
    public val schemaVersionId: Output<String>? = null,
    public val schemaVersionNumber: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSchemaReferenceArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSchemaReferenceArgs =
        com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSchemaReferenceArgs.builder()
            .schemaId(schemaId?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schemaVersionId(schemaVersionId?.applyValue({ args0 -> args0 }))
            .schemaVersionNumber(schemaVersionNumber.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogTableStorageDescriptorSchemaReferenceArgs].
 */
@PulumiTagMarker
public class CatalogTableStorageDescriptorSchemaReferenceArgsBuilder internal constructor() {
    private var schemaId: Output<CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs>? = null

    private var schemaVersionId: Output<String>? = null

    private var schemaVersionNumber: Output<Int>? = null

    /**
     * @param value Configuration block that contains schema identity fields. Either this or the `schema_version_id` has to be provided. See `schema_id` below.
     */
    @JvmName("ndhxxvnwvyrboaly")
    public suspend
    fun schemaId(`value`: Output<CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs>) {
        this.schemaId = value
    }

    /**
     * @param value Unique ID assigned to a version of the schema. Either this or the `schema_id` has to be provided.
     */
    @JvmName("mjpwcmxmbgipqyut")
    public suspend fun schemaVersionId(`value`: Output<String>) {
        this.schemaVersionId = value
    }

    /**
     * @param value Version number of the schema.
     */
    @JvmName("mhfscdxkrcioopjt")
    public suspend fun schemaVersionNumber(`value`: Output<Int>) {
        this.schemaVersionNumber = value
    }

    /**
     * @param value Configuration block that contains schema identity fields. Either this or the `schema_version_id` has to be provided. See `schema_id` below.
     */
    @JvmName("wvuyqtxrxgfidqyg")
    public suspend fun schemaId(`value`: CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaId = mapped
    }

    /**
     * @param argument Configuration block that contains schema identity fields. Either this or the `schema_version_id` has to be provided. See `schema_id` below.
     */
    @JvmName("pfbwvlitgjifokff")
    public suspend
    fun schemaId(argument: suspend CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.schemaId = mapped
    }

    /**
     * @param value Unique ID assigned to a version of the schema. Either this or the `schema_id` has to be provided.
     */
    @JvmName("remnosmedebqhdhx")
    public suspend fun schemaVersionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaVersionId = mapped
    }

    /**
     * @param value Version number of the schema.
     */
    @JvmName("fgvyrbhufyqxnsar")
    public suspend fun schemaVersionNumber(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaVersionNumber = mapped
    }

    internal fun build(): CatalogTableStorageDescriptorSchemaReferenceArgs =
        CatalogTableStorageDescriptorSchemaReferenceArgs(
            schemaId = schemaId,
            schemaVersionId = schemaVersionId,
            schemaVersionNumber = schemaVersionNumber ?: throw PulumiNullFieldException("schemaVersionNumber"),
        )
}
