@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSkewedInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property skewedColumnNames List of names of columns that contain skewed values.
 * @property skewedColumnValueLocationMaps List of values that appear so frequently as to be considered skewed.
 * @property skewedColumnValues Map of skewed values to the columns that contain them.
 */
public data class CatalogTableStorageDescriptorSkewedInfoArgs(
    public val skewedColumnNames: Output<List<String>>? = null,
    public val skewedColumnValueLocationMaps: Output<Map<String, String>>? = null,
    public val skewedColumnValues: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSkewedInfoArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSkewedInfoArgs =
        com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSkewedInfoArgs.builder()
            .skewedColumnNames(skewedColumnNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .skewedColumnValueLocationMaps(
                skewedColumnValueLocationMaps?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .skewedColumnValues(
                skewedColumnValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [CatalogTableStorageDescriptorSkewedInfoArgs].
 */
@PulumiTagMarker
public class CatalogTableStorageDescriptorSkewedInfoArgsBuilder internal constructor() {
    private var skewedColumnNames: Output<List<String>>? = null

    private var skewedColumnValueLocationMaps: Output<Map<String, String>>? = null

    private var skewedColumnValues: Output<List<String>>? = null

    /**
     * @param value List of names of columns that contain skewed values.
     */
    @JvmName("jmlvrcifacsrukcr")
    public suspend fun skewedColumnNames(`value`: Output<List<String>>) {
        this.skewedColumnNames = value
    }

    @JvmName("ssicldqeeubdbggf")
    public suspend fun skewedColumnNames(vararg values: Output<String>) {
        this.skewedColumnNames = Output.all(values.asList())
    }

    /**
     * @param values List of names of columns that contain skewed values.
     */
    @JvmName("uqagyanscwlgcuil")
    public suspend fun skewedColumnNames(values: List<Output<String>>) {
        this.skewedColumnNames = Output.all(values)
    }

    /**
     * @param value List of values that appear so frequently as to be considered skewed.
     */
    @JvmName("qhgepwowqyoeuilo")
    public suspend fun skewedColumnValueLocationMaps(`value`: Output<Map<String, String>>) {
        this.skewedColumnValueLocationMaps = value
    }

    /**
     * @param value Map of skewed values to the columns that contain them.
     */
    @JvmName("yjtuivqqkglmvsdt")
    public suspend fun skewedColumnValues(`value`: Output<List<String>>) {
        this.skewedColumnValues = value
    }

    @JvmName("ydqaqnxfjkyaethb")
    public suspend fun skewedColumnValues(vararg values: Output<String>) {
        this.skewedColumnValues = Output.all(values.asList())
    }

    /**
     * @param values Map of skewed values to the columns that contain them.
     */
    @JvmName("ltwsllswmnbndhxy")
    public suspend fun skewedColumnValues(values: List<Output<String>>) {
        this.skewedColumnValues = Output.all(values)
    }

    /**
     * @param value List of names of columns that contain skewed values.
     */
    @JvmName("tlwiyxrfjmgqyepp")
    public suspend fun skewedColumnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skewedColumnNames = mapped
    }

    /**
     * @param values List of names of columns that contain skewed values.
     */
    @JvmName("jxiclcvfsqynmofy")
    public suspend fun skewedColumnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skewedColumnNames = mapped
    }

    /**
     * @param value List of values that appear so frequently as to be considered skewed.
     */
    @JvmName("oqvoqrmylndtxnav")
    public suspend fun skewedColumnValueLocationMaps(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skewedColumnValueLocationMaps = mapped
    }

    /**
     * @param values List of values that appear so frequently as to be considered skewed.
     */
    @JvmName("cdrmewcupedokctr")
    public fun skewedColumnValueLocationMaps(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skewedColumnValueLocationMaps = mapped
    }

    /**
     * @param value Map of skewed values to the columns that contain them.
     */
    @JvmName("kobtbyqonovdpwyq")
    public suspend fun skewedColumnValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skewedColumnValues = mapped
    }

    /**
     * @param values Map of skewed values to the columns that contain them.
     */
    @JvmName("yrjjdjfesndguaks")
    public suspend fun skewedColumnValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skewedColumnValues = mapped
    }

    internal fun build(): CatalogTableStorageDescriptorSkewedInfoArgs =
        CatalogTableStorageDescriptorSkewedInfoArgs(
            skewedColumnNames = skewedColumnNames,
            skewedColumnValueLocationMaps = skewedColumnValueLocationMaps,
            skewedColumnValues = skewedColumnValues,
        )
}
