@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.ClassifierJsonClassifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jsonPath A `JsonPath` string defining the JSON data for the classifier to classify. AWS Glue supports a subset of `JsonPath`, as described in [Writing JsonPath Custom Classifiers](https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
 */
public data class ClassifierJsonClassifierArgs(
    public val jsonPath: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.ClassifierJsonClassifierArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.ClassifierJsonClassifierArgs =
        com.pulumi.aws.glue.inputs.ClassifierJsonClassifierArgs.builder()
            .jsonPath(jsonPath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClassifierJsonClassifierArgs].
 */
@PulumiTagMarker
public class ClassifierJsonClassifierArgsBuilder internal constructor() {
    private var jsonPath: Output<String>? = null

    /**
     * @param value A `JsonPath` string defining the JSON data for the classifier to classify. AWS Glue supports a subset of `JsonPath`, as described in [Writing JsonPath Custom Classifiers](https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
     */
    @JvmName("gpbnhuuegjweoljo")
    public suspend fun jsonPath(`value`: Output<String>) {
        this.jsonPath = value
    }

    /**
     * @param value A `JsonPath` string defining the JSON data for the classifier to classify. AWS Glue supports a subset of `JsonPath`, as described in [Writing JsonPath Custom Classifiers](https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
     */
    @JvmName("xxwgvihbnqdyxmjs")
    public suspend fun jsonPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jsonPath = mapped
    }

    internal fun build(): ClassifierJsonClassifierArgs = ClassifierJsonClassifierArgs(
        jsonPath = jsonPath ?: throw PulumiNullFieldException("jsonPath"),
    )
}
