@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CrawlerCatalogTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
 * @property databaseName The name of the Glue database to be synchronized.
 * @property dlqEventQueueArn A valid Amazon SQS ARN.
 * > **Note:** `deletion_behavior` of catalog target doesn't support `DEPRECATE_IN_DATABASE`.
 * > **Note:** `configuration` for catalog target crawlers will have `{ ... "Grouping": { "TableGroupingPolicy": "CombineCompatibleSchemas"} }` by default.
 * @property eventQueueArn A valid Amazon SQS ARN.
 * @property tables A list of catalog tables to be synchronized.
 */
public data class CrawlerCatalogTargetArgs(
    public val connectionName: Output<String>? = null,
    public val databaseName: Output<String>,
    public val dlqEventQueueArn: Output<String>? = null,
    public val eventQueueArn: Output<String>? = null,
    public val tables: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CrawlerCatalogTargetArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CrawlerCatalogTargetArgs =
        com.pulumi.aws.glue.inputs.CrawlerCatalogTargetArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .dlqEventQueueArn(dlqEventQueueArn?.applyValue({ args0 -> args0 }))
            .eventQueueArn(eventQueueArn?.applyValue({ args0 -> args0 }))
            .tables(tables.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CrawlerCatalogTargetArgs].
 */
@PulumiTagMarker
public class CrawlerCatalogTargetArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var dlqEventQueueArn: Output<String>? = null

    private var eventQueueArn: Output<String>? = null

    private var tables: Output<List<String>>? = null

    /**
     * @param value The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
     */
    @JvmName("nvnqwfsbocvrxlle")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value The name of the Glue database to be synchronized.
     */
    @JvmName("moihmwrlcfyttqjm")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value A valid Amazon SQS ARN.
     * > **Note:** `deletion_behavior` of catalog target doesn't support `DEPRECATE_IN_DATABASE`.
     * > **Note:** `configuration` for catalog target crawlers will have `{ ... "Grouping": { "TableGroupingPolicy": "CombineCompatibleSchemas"} }` by default.
     */
    @JvmName("lvpkeiedhhcqqauk")
    public suspend fun dlqEventQueueArn(`value`: Output<String>) {
        this.dlqEventQueueArn = value
    }

    /**
     * @param value A valid Amazon SQS ARN.
     */
    @JvmName("vdljoxkhyuboojyc")
    public suspend fun eventQueueArn(`value`: Output<String>) {
        this.eventQueueArn = value
    }

    /**
     * @param value A list of catalog tables to be synchronized.
     */
    @JvmName("iiivpfvdwbwwrovi")
    public suspend fun tables(`value`: Output<List<String>>) {
        this.tables = value
    }

    @JvmName("ogelljfkmeinebtj")
    public suspend fun tables(vararg values: Output<String>) {
        this.tables = Output.all(values.asList())
    }

    /**
     * @param values A list of catalog tables to be synchronized.
     */
    @JvmName("vilqanywbdoqkdsi")
    public suspend fun tables(values: List<Output<String>>) {
        this.tables = Output.all(values)
    }

    /**
     * @param value The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
     */
    @JvmName("srsobicsilmmtpwl")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value The name of the Glue database to be synchronized.
     */
    @JvmName("gjjqvekdxfngsbgu")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value A valid Amazon SQS ARN.
     * > **Note:** `deletion_behavior` of catalog target doesn't support `DEPRECATE_IN_DATABASE`.
     * > **Note:** `configuration` for catalog target crawlers will have `{ ... "Grouping": { "TableGroupingPolicy": "CombineCompatibleSchemas"} }` by default.
     */
    @JvmName("inilslfgrmgujpsb")
    public suspend fun dlqEventQueueArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dlqEventQueueArn = mapped
    }

    /**
     * @param value A valid Amazon SQS ARN.
     */
    @JvmName("bjmeepwtrhpdsxvt")
    public suspend fun eventQueueArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventQueueArn = mapped
    }

    /**
     * @param value A list of catalog tables to be synchronized.
     */
    @JvmName("uqvimdllpqeugtgv")
    public suspend fun tables(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tables = mapped
    }

    /**
     * @param values A list of catalog tables to be synchronized.
     */
    @JvmName("uujuvdenpshwcosi")
    public suspend fun tables(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tables = mapped
    }

    internal fun build(): CrawlerCatalogTargetArgs = CrawlerCatalogTargetArgs(
        connectionName = connectionName,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        dlqEventQueueArn = dlqEventQueueArn,
        eventQueueArn = eventQueueArn,
        tables = tables ?: throw PulumiNullFieldException("tables"),
    )
}
