@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CrawlerJdbcTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name of the connection to use to connect to the JDBC target.
 * @property enableAdditionalMetadatas Specify a value of `RAWTYPES` or `COMMENTS` to enable additional metadata intable responses. `RAWTYPES` provides the native-level datatype. `COMMENTS` provides comments associated with a column or table in the database.
 * @property exclusions A list of glob patterns used to exclude from the crawl.
 * @property path The path of the JDBC target.
 */
public data class CrawlerJdbcTargetArgs(
    public val connectionName: Output<String>,
    public val enableAdditionalMetadatas: Output<List<String>>? = null,
    public val exclusions: Output<List<String>>? = null,
    public val path: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CrawlerJdbcTargetArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CrawlerJdbcTargetArgs =
        com.pulumi.aws.glue.inputs.CrawlerJdbcTargetArgs.builder()
            .connectionName(connectionName.applyValue({ args0 -> args0 }))
            .enableAdditionalMetadatas(
                enableAdditionalMetadatas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .exclusions(exclusions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .path(path.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CrawlerJdbcTargetArgs].
 */
@PulumiTagMarker
public class CrawlerJdbcTargetArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var enableAdditionalMetadatas: Output<List<String>>? = null

    private var exclusions: Output<List<String>>? = null

    private var path: Output<String>? = null

    /**
     * @param value The name of the connection to use to connect to the JDBC target.
     */
    @JvmName("atgiaqqqjidfcvge")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Specify a value of `RAWTYPES` or `COMMENTS` to enable additional metadata intable responses. `RAWTYPES` provides the native-level datatype. `COMMENTS` provides comments associated with a column or table in the database.
     */
    @JvmName("tgomrxhaedmatqnm")
    public suspend fun enableAdditionalMetadatas(`value`: Output<List<String>>) {
        this.enableAdditionalMetadatas = value
    }

    @JvmName("thhigmfemtampbtp")
    public suspend fun enableAdditionalMetadatas(vararg values: Output<String>) {
        this.enableAdditionalMetadatas = Output.all(values.asList())
    }

    /**
     * @param values Specify a value of `RAWTYPES` or `COMMENTS` to enable additional metadata intable responses. `RAWTYPES` provides the native-level datatype. `COMMENTS` provides comments associated with a column or table in the database.
     */
    @JvmName("tmyqixonguwvvdnv")
    public suspend fun enableAdditionalMetadatas(values: List<Output<String>>) {
        this.enableAdditionalMetadatas = Output.all(values)
    }

    /**
     * @param value A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("sixanbdntfpsqqxy")
    public suspend fun exclusions(`value`: Output<List<String>>) {
        this.exclusions = value
    }

    @JvmName("icfbfianccwfhijf")
    public suspend fun exclusions(vararg values: Output<String>) {
        this.exclusions = Output.all(values.asList())
    }

    /**
     * @param values A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("meakdvbameypsuna")
    public suspend fun exclusions(values: List<Output<String>>) {
        this.exclusions = Output.all(values)
    }

    /**
     * @param value The path of the JDBC target.
     */
    @JvmName("omanyjxmfgelaedm")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The name of the connection to use to connect to the JDBC target.
     */
    @JvmName("gvdkubpmsofwibee")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Specify a value of `RAWTYPES` or `COMMENTS` to enable additional metadata intable responses. `RAWTYPES` provides the native-level datatype. `COMMENTS` provides comments associated with a column or table in the database.
     */
    @JvmName("ggwijofkaharjkrx")
    public suspend fun enableAdditionalMetadatas(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAdditionalMetadatas = mapped
    }

    /**
     * @param values Specify a value of `RAWTYPES` or `COMMENTS` to enable additional metadata intable responses. `RAWTYPES` provides the native-level datatype. `COMMENTS` provides comments associated with a column or table in the database.
     */
    @JvmName("ieuynhfoiyhvwltc")
    public suspend fun enableAdditionalMetadatas(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableAdditionalMetadatas = mapped
    }

    /**
     * @param value A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("kcsquhxtbedoswtn")
    public suspend fun exclusions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param values A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("xmhqowgyjdrpkbjm")
    public suspend fun exclusions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param value The path of the JDBC target.
     */
    @JvmName("bhniqcjsfquqbklk")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): CrawlerJdbcTargetArgs = CrawlerJdbcTargetArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        enableAdditionalMetadatas = enableAdditionalMetadatas,
        exclusions = exclusions,
        path = path ?: throw PulumiNullFieldException("path"),
    )
}
