@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CrawlerLakeFormationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountId Required for cross account crawls. For same account crawls as the target data, this can omitted.
 * @property useLakeFormationCredentials Specifies whether to use Lake Formation credentials for the crawler instead of the IAM role credentials.
 */
public data class CrawlerLakeFormationConfigurationArgs(
    public val accountId: Output<String>? = null,
    public val useLakeFormationCredentials: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CrawlerLakeFormationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CrawlerLakeFormationConfigurationArgs =
        com.pulumi.aws.glue.inputs.CrawlerLakeFormationConfigurationArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .useLakeFormationCredentials(useLakeFormationCredentials?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CrawlerLakeFormationConfigurationArgs].
 */
@PulumiTagMarker
public class CrawlerLakeFormationConfigurationArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var useLakeFormationCredentials: Output<Boolean>? = null

    /**
     * @param value Required for cross account crawls. For same account crawls as the target data, this can omitted.
     */
    @JvmName("ueonsfrlyjjyrbbd")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Specifies whether to use Lake Formation credentials for the crawler instead of the IAM role credentials.
     */
    @JvmName("tkfeaddyqqiwuaiw")
    public suspend fun useLakeFormationCredentials(`value`: Output<Boolean>) {
        this.useLakeFormationCredentials = value
    }

    /**
     * @param value Required for cross account crawls. For same account crawls as the target data, this can omitted.
     */
    @JvmName("maenwqqvahrpwbro")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Specifies whether to use Lake Formation credentials for the crawler instead of the IAM role credentials.
     */
    @JvmName("jfvryqtcwmiemgov")
    public suspend fun useLakeFormationCredentials(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useLakeFormationCredentials = mapped
    }

    internal fun build(): CrawlerLakeFormationConfigurationArgs =
        CrawlerLakeFormationConfigurationArgs(
            accountId = accountId,
            useLakeFormationCredentials = useLakeFormationCredentials,
        )
}
