@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CrawlerLineageConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property crawlerLineageSettings Specifies whether data lineage is enabled for the crawler. Valid values are: `ENABLE` and `DISABLE`. Default value is `DISABLE`.
 */
public data class CrawlerLineageConfigurationArgs(
    public val crawlerLineageSettings: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CrawlerLineageConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CrawlerLineageConfigurationArgs =
        com.pulumi.aws.glue.inputs.CrawlerLineageConfigurationArgs.builder()
            .crawlerLineageSettings(crawlerLineageSettings?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CrawlerLineageConfigurationArgs].
 */
@PulumiTagMarker
public class CrawlerLineageConfigurationArgsBuilder internal constructor() {
    private var crawlerLineageSettings: Output<String>? = null

    /**
     * @param value Specifies whether data lineage is enabled for the crawler. Valid values are: `ENABLE` and `DISABLE`. Default value is `DISABLE`.
     */
    @JvmName("kdfrffwtvsnpsqif")
    public suspend fun crawlerLineageSettings(`value`: Output<String>) {
        this.crawlerLineageSettings = value
    }

    /**
     * @param value Specifies whether data lineage is enabled for the crawler. Valid values are: `ENABLE` and `DISABLE`. Default value is `DISABLE`.
     */
    @JvmName("qpiwksxnueynixsh")
    public suspend fun crawlerLineageSettings(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crawlerLineageSettings = mapped
    }

    internal fun build(): CrawlerLineageConfigurationArgs = CrawlerLineageConfigurationArgs(
        crawlerLineageSettings = crawlerLineageSettings,
    )
}
