@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CrawlerRecrawlPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property recrawlBehavior Specifies whether to crawl the entire dataset again, crawl only folders that were added since the last crawler run, or crawl what S3 notifies the crawler of via SQS. Valid Values are: `CRAWL_EVENT_MODE`, `CRAWL_EVERYTHING` and `CRAWL_NEW_FOLDERS_ONLY`. Default value is `CRAWL_EVERYTHING`.
 */
public data class CrawlerRecrawlPolicyArgs(
    public val recrawlBehavior: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CrawlerRecrawlPolicyArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CrawlerRecrawlPolicyArgs =
        com.pulumi.aws.glue.inputs.CrawlerRecrawlPolicyArgs.builder()
            .recrawlBehavior(recrawlBehavior?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CrawlerRecrawlPolicyArgs].
 */
@PulumiTagMarker
public class CrawlerRecrawlPolicyArgsBuilder internal constructor() {
    private var recrawlBehavior: Output<String>? = null

    /**
     * @param value Specifies whether to crawl the entire dataset again, crawl only folders that were added since the last crawler run, or crawl what S3 notifies the crawler of via SQS. Valid Values are: `CRAWL_EVENT_MODE`, `CRAWL_EVERYTHING` and `CRAWL_NEW_FOLDERS_ONLY`. Default value is `CRAWL_EVERYTHING`.
     */
    @JvmName("tlixwlwbkyehwcsv")
    public suspend fun recrawlBehavior(`value`: Output<String>) {
        this.recrawlBehavior = value
    }

    /**
     * @param value Specifies whether to crawl the entire dataset again, crawl only folders that were added since the last crawler run, or crawl what S3 notifies the crawler of via SQS. Valid Values are: `CRAWL_EVENT_MODE`, `CRAWL_EVERYTHING` and `CRAWL_NEW_FOLDERS_ONLY`. Default value is `CRAWL_EVERYTHING`.
     */
    @JvmName("wthfmgrgpvjdncge")
    public suspend fun recrawlBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recrawlBehavior = mapped
    }

    internal fun build(): CrawlerRecrawlPolicyArgs = CrawlerRecrawlPolicyArgs(
        recrawlBehavior = recrawlBehavior,
    )
}
