@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CrawlerS3TargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
 * @property dlqEventQueueArn A valid Amazon SQS ARN.
 * > **Note:** `deletion_behavior` of catalog target doesn't support `DEPRECATE_IN_DATABASE`.
 * > **Note:** `configuration` for catalog target crawlers will have `{ ... "Grouping": { "TableGroupingPolicy": "CombineCompatibleSchemas"} }` by default.
 * @property eventQueueArn A valid Amazon SQS ARN.
 * @property exclusions A list of glob patterns used to exclude from the crawl.
 * @property path The name of the DynamoDB table to crawl.
 * @property sampleSize Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
 */
public data class CrawlerS3TargetArgs(
    public val connectionName: Output<String>? = null,
    public val dlqEventQueueArn: Output<String>? = null,
    public val eventQueueArn: Output<String>? = null,
    public val exclusions: Output<List<String>>? = null,
    public val path: Output<String>,
    public val sampleSize: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CrawlerS3TargetArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CrawlerS3TargetArgs =
        com.pulumi.aws.glue.inputs.CrawlerS3TargetArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .dlqEventQueueArn(dlqEventQueueArn?.applyValue({ args0 -> args0 }))
            .eventQueueArn(eventQueueArn?.applyValue({ args0 -> args0 }))
            .exclusions(exclusions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .path(path.applyValue({ args0 -> args0 }))
            .sampleSize(sampleSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CrawlerS3TargetArgs].
 */
@PulumiTagMarker
public class CrawlerS3TargetArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var dlqEventQueueArn: Output<String>? = null

    private var eventQueueArn: Output<String>? = null

    private var exclusions: Output<List<String>>? = null

    private var path: Output<String>? = null

    private var sampleSize: Output<Int>? = null

    /**
     * @param value The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
     */
    @JvmName("rgulfkvjdtxllgpd")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value A valid Amazon SQS ARN.
     * > **Note:** `deletion_behavior` of catalog target doesn't support `DEPRECATE_IN_DATABASE`.
     * > **Note:** `configuration` for catalog target crawlers will have `{ ... "Grouping": { "TableGroupingPolicy": "CombineCompatibleSchemas"} }` by default.
     */
    @JvmName("srcdotxjhbfckrwt")
    public suspend fun dlqEventQueueArn(`value`: Output<String>) {
        this.dlqEventQueueArn = value
    }

    /**
     * @param value A valid Amazon SQS ARN.
     */
    @JvmName("cgobvnhemvqmoaqk")
    public suspend fun eventQueueArn(`value`: Output<String>) {
        this.eventQueueArn = value
    }

    /**
     * @param value A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("bwweuepfqkohrnqg")
    public suspend fun exclusions(`value`: Output<List<String>>) {
        this.exclusions = value
    }

    @JvmName("rstnblbuwhhcfikn")
    public suspend fun exclusions(vararg values: Output<String>) {
        this.exclusions = Output.all(values.asList())
    }

    /**
     * @param values A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("nmlppxtjvichwiqg")
    public suspend fun exclusions(values: List<Output<String>>) {
        this.exclusions = Output.all(values)
    }

    /**
     * @param value The name of the DynamoDB table to crawl.
     */
    @JvmName("ttqvkchbnlvmfnew")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
     */
    @JvmName("dowjylmhewwwdxwl")
    public suspend fun sampleSize(`value`: Output<Int>) {
        this.sampleSize = value
    }

    /**
     * @param value The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
     */
    @JvmName("prsfgkfwhtrslxlh")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value A valid Amazon SQS ARN.
     * > **Note:** `deletion_behavior` of catalog target doesn't support `DEPRECATE_IN_DATABASE`.
     * > **Note:** `configuration` for catalog target crawlers will have `{ ... "Grouping": { "TableGroupingPolicy": "CombineCompatibleSchemas"} }` by default.
     */
    @JvmName("pkarfeuqidbgddef")
    public suspend fun dlqEventQueueArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dlqEventQueueArn = mapped
    }

    /**
     * @param value A valid Amazon SQS ARN.
     */
    @JvmName("dictmbggpxyoxadh")
    public suspend fun eventQueueArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventQueueArn = mapped
    }

    /**
     * @param value A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("tssnlwfbckybnkdr")
    public suspend fun exclusions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param values A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("xokpbiuabaqentky")
    public suspend fun exclusions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param value The name of the DynamoDB table to crawl.
     */
    @JvmName("ietvsdfmxlmggbqx")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
     */
    @JvmName("ajoyythkqmhiwtea")
    public suspend fun sampleSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleSize = mapped
    }

    internal fun build(): CrawlerS3TargetArgs = CrawlerS3TargetArgs(
        connectionName = connectionName,
        dlqEventQueueArn = dlqEventQueueArn,
        eventQueueArn = eventQueueArn,
        exclusions = exclusions,
        path = path ?: throw PulumiNullFieldException("path"),
        sampleSize = sampleSize,
    )
}
