@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property connectionPasswordEncryption When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
 * @property encryptionAtRest Specifies the encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
 */
public data class DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs(
    public val connectionPasswordEncryption:
    Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs>,
    public val encryptionAtRest:
    Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs =
        com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs.builder()
            .connectionPasswordEncryption(
                connectionPasswordEncryption.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .encryptionAtRest(
                encryptionAtRest.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs].
 */
@PulumiTagMarker
public class DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsBuilder internal
constructor() {
    private var connectionPasswordEncryption:
        Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs>? =
        null

    private var encryptionAtRest:
        Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs>? = null

    /**
     * @param value When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
     */
    @JvmName("vsmdwbmrqvkkolhi")
    public suspend
    fun connectionPasswordEncryption(`value`: Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs>) {
        this.connectionPasswordEncryption = value
    }

    /**
     * @param value Specifies the encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
     */
    @JvmName("sanmhapilvxjxkag")
    public suspend
    fun encryptionAtRest(`value`: Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs>) {
        this.encryptionAtRest = value
    }

    /**
     * @param value When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
     */
    @JvmName("fxsytuqerqttmltw")
    public suspend
    fun connectionPasswordEncryption(`value`: DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionPasswordEncryption = mapped
    }

    /**
     * @param argument When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD field in the connection properties. You can enable catalog encryption or only password encryption. see Connection Password Encryption.
     */
    @JvmName("wlaqyxdyqmlwwoku")
    public suspend
    fun connectionPasswordEncryption(argument: suspend DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.connectionPasswordEncryption = mapped
    }

    /**
     * @param value Specifies the encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
     */
    @JvmName("csqqtxgiivupeuls")
    public suspend
    fun encryptionAtRest(`value`: DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAtRest = mapped
    }

    /**
     * @param argument Specifies the encryption-at-rest configuration for the Data Catalog. see Encryption At Rest.
     */
    @JvmName("idyismmhvjymnknn")
    public suspend
    fun encryptionAtRest(argument: suspend DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.encryptionAtRest = mapped
    }

    internal fun build(): DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs =
        DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs(
            connectionPasswordEncryption = connectionPasswordEncryption ?: throw
                PulumiNullFieldException("connectionPasswordEncryption"),
            encryptionAtRest = encryptionAtRest ?: throw PulumiNullFieldException("encryptionAtRest"),
        )
}
