@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property awsKmsKeyId A KMS key ARN that is used to encrypt the connection password. If connection password protection is enabled, the caller of CreateConnection and UpdateConnection needs at least `kms:Encrypt` permission on the specified AWS KMS key, to encrypt passwords before storing them in the Data Catalog.
 * @property returnConnectionPasswordEncrypted When set to `true`, passwords remain encrypted in the responses of GetConnection and GetConnections. This encryption takes effect independently of the catalog encryption.
 */
public data class
DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs(
    public val awsKmsKeyId: Output<String>? = null,
    public val returnConnectionPasswordEncrypted: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs> {
    override fun toJava():
        com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs =
        com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs.builder()
            .awsKmsKeyId(awsKmsKeyId?.applyValue({ args0 -> args0 }))
            .returnConnectionPasswordEncrypted(
                returnConnectionPasswordEncrypted.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs].
 */
@PulumiTagMarker
public class
DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgsBuilder
internal constructor() {
    private var awsKmsKeyId: Output<String>? = null

    private var returnConnectionPasswordEncrypted: Output<Boolean>? = null

    /**
     * @param value A KMS key ARN that is used to encrypt the connection password. If connection password protection is enabled, the caller of CreateConnection and UpdateConnection needs at least `kms:Encrypt` permission on the specified AWS KMS key, to encrypt passwords before storing them in the Data Catalog.
     */
    @JvmName("hkxfrngogutudmyu")
    public suspend fun awsKmsKeyId(`value`: Output<String>) {
        this.awsKmsKeyId = value
    }

    /**
     * @param value When set to `true`, passwords remain encrypted in the responses of GetConnection and GetConnections. This encryption takes effect independently of the catalog encryption.
     */
    @JvmName("gtwupuljhaclpkws")
    public suspend fun returnConnectionPasswordEncrypted(`value`: Output<Boolean>) {
        this.returnConnectionPasswordEncrypted = value
    }

    /**
     * @param value A KMS key ARN that is used to encrypt the connection password. If connection password protection is enabled, the caller of CreateConnection and UpdateConnection needs at least `kms:Encrypt` permission on the specified AWS KMS key, to encrypt passwords before storing them in the Data Catalog.
     */
    @JvmName("xfhqwqfsuwdlecqy")
    public suspend fun awsKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsKmsKeyId = mapped
    }

    /**
     * @param value When set to `true`, passwords remain encrypted in the responses of GetConnection and GetConnections. This encryption takes effect independently of the catalog encryption.
     */
    @JvmName("ppillnhcsgifkvxm")
    public suspend fun returnConnectionPasswordEncrypted(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.returnConnectionPasswordEncrypted = mapped
    }

    internal fun build():
        DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs =
        DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs(
            awsKmsKeyId = awsKmsKeyId,
            returnConnectionPasswordEncrypted = returnConnectionPasswordEncrypted ?: throw
                PulumiNullFieldException("returnConnectionPasswordEncrypted"),
        )
}
