@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.GetDataCatalogEncryptionSettingsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDataCatalogEncryptionSettings.
 * @property catalogId ID of the Data Catalog. This is typically the AWS account ID.
 */
public data class GetDataCatalogEncryptionSettingsPlainArgs(
    public val catalogId: String,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.GetDataCatalogEncryptionSettingsPlainArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.GetDataCatalogEncryptionSettingsPlainArgs =
        com.pulumi.aws.glue.inputs.GetDataCatalogEncryptionSettingsPlainArgs.builder()
            .catalogId(catalogId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataCatalogEncryptionSettingsPlainArgs].
 */
@PulumiTagMarker
public class GetDataCatalogEncryptionSettingsPlainArgsBuilder internal constructor() {
    private var catalogId: String? = null

    /**
     * @param value ID of the Data Catalog. This is typically the AWS account ID.
     */
    @JvmName("rrgimscvmuvwuqad")
    public suspend fun catalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogId = mapped
    }

    internal fun build(): GetDataCatalogEncryptionSettingsPlainArgs =
        GetDataCatalogEncryptionSettingsPlainArgs(
            catalogId = catalogId ?: throw PulumiNullFieldException("catalogId"),
        )
}
