@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.GetScriptDagEdge.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property source ID of the node at which the edge starts.
 * @property target ID of the node at which the edge ends.
 * @property targetParameter Target of the edge.
 */
public data class GetScriptDagEdge(
    public val source: String,
    public val target: String,
    public val targetParameter: String? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.GetScriptDagEdge> {
    override fun toJava(): com.pulumi.aws.glue.inputs.GetScriptDagEdge =
        com.pulumi.aws.glue.inputs.GetScriptDagEdge.builder()
            .source(source.let({ args0 -> args0 }))
            .target(target.let({ args0 -> args0 }))
            .targetParameter(targetParameter?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScriptDagEdge].
 */
@PulumiTagMarker
public class GetScriptDagEdgeBuilder internal constructor() {
    private var source: String? = null

    private var target: String? = null

    private var targetParameter: String? = null

    /**
     * @param value ID of the node at which the edge starts.
     */
    @JvmName("kqxegvwunjcvevlg")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.source = mapped
    }

    /**
     * @param value ID of the node at which the edge ends.
     */
    @JvmName("najmsvxgkxeswuxt")
    public suspend fun target(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.target = mapped
    }

    /**
     * @param value Target of the edge.
     */
    @JvmName("bfaqjkqjygrbonpb")
    public suspend fun targetParameter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.targetParameter = mapped
    }

    internal fun build(): GetScriptDagEdge = GetScriptDagEdge(
        source = source ?: throw PulumiNullFieldException("source"),
        target = target ?: throw PulumiNullFieldException("target"),
        targetParameter = targetParameter,
    )
}
