@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.GetScriptDagNode.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property args Nested configuration an argument or property of a node. Defined below.
 * @property id Node identifier that is unique within the node's graph.
 * @property lineNumber Line number of the node.
 * @property nodeType Type of node this is.
 */
public data class GetScriptDagNode(
    public val args: List<GetScriptDagNodeArg>,
    public val id: String,
    public val lineNumber: Int? = null,
    public val nodeType: String,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.GetScriptDagNode> {
    override fun toJava(): com.pulumi.aws.glue.inputs.GetScriptDagNode =
        com.pulumi.aws.glue.inputs.GetScriptDagNode.builder()
            .args(args.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id.let({ args0 -> args0 }))
            .lineNumber(lineNumber?.let({ args0 -> args0 }))
            .nodeType(nodeType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScriptDagNode].
 */
@PulumiTagMarker
public class GetScriptDagNodeBuilder internal constructor() {
    private var args: List<GetScriptDagNodeArg>? = null

    private var id: String? = null

    private var lineNumber: Int? = null

    private var nodeType: String? = null

    /**
     * @param value Nested configuration an argument or property of a node. Defined below.
     */
    @JvmName("vhiabacghnaladkc")
    public suspend fun args(`value`: List<GetScriptDagNodeArg>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.args = mapped
    }

    /**
     * @param argument Nested configuration an argument or property of a node. Defined below.
     */
    @JvmName("npnswgampfpwwskm")
    public suspend fun args(argument: List<suspend GetScriptDagNodeArgBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetScriptDagNodeArgBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.args = mapped
    }

    /**
     * @param argument Nested configuration an argument or property of a node. Defined below.
     */
    @JvmName("xncaibaryjsbibmf")
    public suspend fun args(vararg argument: suspend GetScriptDagNodeArgBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetScriptDagNodeArgBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.args = mapped
    }

    /**
     * @param argument Nested configuration an argument or property of a node. Defined below.
     */
    @JvmName("emvxiaftumathoxc")
    public suspend fun args(argument: suspend GetScriptDagNodeArgBuilder.() -> Unit) {
        val toBeMapped = listOf(GetScriptDagNodeArgBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.args = mapped
    }

    /**
     * @param values Nested configuration an argument or property of a node. Defined below.
     */
    @JvmName("swlgqdonngxybbtt")
    public suspend fun args(vararg values: GetScriptDagNodeArg) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.args = mapped
    }

    /**
     * @param value Node identifier that is unique within the node's graph.
     */
    @JvmName("nsommfjqqdoupdrh")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Line number of the node.
     */
    @JvmName("shqdwtkqwkruuook")
    public suspend fun lineNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lineNumber = mapped
    }

    /**
     * @param value Type of node this is.
     */
    @JvmName("vwywqyfvukffhhwh")
    public suspend fun nodeType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nodeType = mapped
    }

    internal fun build(): GetScriptDagNode = GetScriptDagNode(
        args = args ?: throw PulumiNullFieldException("args"),
        id = id ?: throw PulumiNullFieldException("id"),
        lineNumber = lineNumber,
        nodeType = nodeType ?: throw PulumiNullFieldException("nodeType"),
    )
}
