@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.JobCommandArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the job command. Defaults to `glueetl`. Use `pythonshell` for Python Shell Job Type, `glueray` for Ray Job Type, or `gluestreaming` for Streaming Job Type. `max_capacity` needs to be set if `pythonshell` is chosen.
 * @property pythonVersion The Python version being used to execute a Python shell job. Allowed values are 2, 3 or 3.9. Version 3 refers to Python 3.6.
 * @property runtime In Ray jobs, runtime is used to specify the versions of Ray, Python and additional libraries available in your environment. This field is not used in other job types. For supported runtime environment values, see [Working with Ray jobs](https://docs.aws.amazon.com/glue/latest/dg/ray-jobs-section.html#author-job-ray-runtimes) in the Glue Developer Guide.
 * @property scriptLocation Specifies the S3 path to a script that executes a job.
 */
public data class JobCommandArgs(
    public val name: Output<String>? = null,
    public val pythonVersion: Output<String>? = null,
    public val runtime: Output<String>? = null,
    public val scriptLocation: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.JobCommandArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.JobCommandArgs =
        com.pulumi.aws.glue.inputs.JobCommandArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .pythonVersion(pythonVersion?.applyValue({ args0 -> args0 }))
            .runtime(runtime?.applyValue({ args0 -> args0 }))
            .scriptLocation(scriptLocation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobCommandArgs].
 */
@PulumiTagMarker
public class JobCommandArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var pythonVersion: Output<String>? = null

    private var runtime: Output<String>? = null

    private var scriptLocation: Output<String>? = null

    /**
     * @param value The name of the job command. Defaults to `glueetl`. Use `pythonshell` for Python Shell Job Type, `glueray` for Ray Job Type, or `gluestreaming` for Streaming Job Type. `max_capacity` needs to be set if `pythonshell` is chosen.
     */
    @JvmName("nspvgbuxfmlddrrk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Python version being used to execute a Python shell job. Allowed values are 2, 3 or 3.9. Version 3 refers to Python 3.6.
     */
    @JvmName("lcmxigxybhpeirah")
    public suspend fun pythonVersion(`value`: Output<String>) {
        this.pythonVersion = value
    }

    /**
     * @param value In Ray jobs, runtime is used to specify the versions of Ray, Python and additional libraries available in your environment. This field is not used in other job types. For supported runtime environment values, see [Working with Ray jobs](https://docs.aws.amazon.com/glue/latest/dg/ray-jobs-section.html#author-job-ray-runtimes) in the Glue Developer Guide.
     */
    @JvmName("mxnnuywqvyymcisk")
    public suspend fun runtime(`value`: Output<String>) {
        this.runtime = value
    }

    /**
     * @param value Specifies the S3 path to a script that executes a job.
     */
    @JvmName("uqhbfsramtjciffr")
    public suspend fun scriptLocation(`value`: Output<String>) {
        this.scriptLocation = value
    }

    /**
     * @param value The name of the job command. Defaults to `glueetl`. Use `pythonshell` for Python Shell Job Type, `glueray` for Ray Job Type, or `gluestreaming` for Streaming Job Type. `max_capacity` needs to be set if `pythonshell` is chosen.
     */
    @JvmName("gemekdsquitgokng")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Python version being used to execute a Python shell job. Allowed values are 2, 3 or 3.9. Version 3 refers to Python 3.6.
     */
    @JvmName("iancfyarbbhwbaml")
    public suspend fun pythonVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pythonVersion = mapped
    }

    /**
     * @param value In Ray jobs, runtime is used to specify the versions of Ray, Python and additional libraries available in your environment. This field is not used in other job types. For supported runtime environment values, see [Working with Ray jobs](https://docs.aws.amazon.com/glue/latest/dg/ray-jobs-section.html#author-job-ray-runtimes) in the Glue Developer Guide.
     */
    @JvmName("gkdcylbiucepnqey")
    public suspend fun runtime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param value Specifies the S3 path to a script that executes a job.
     */
    @JvmName("ppiqlkidqbxfowwf")
    public suspend fun scriptLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scriptLocation = mapped
    }

    internal fun build(): JobCommandArgs = JobCommandArgs(
        name = name,
        pythonVersion = pythonVersion,
        runtime = runtime,
        scriptLocation = scriptLocation ?: throw PulumiNullFieldException("scriptLocation"),
    )
}
