@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.MLTransformInputRecordTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId A unique identifier for the AWS Glue Data Catalog.
 * @property connectionName The name of the connection to the AWS Glue Data Catalog.
 * @property databaseName A database name in the AWS Glue Data Catalog.
 * @property tableName A table name in the AWS Glue Data Catalog.
 */
public data class MLTransformInputRecordTableArgs(
    public val catalogId: Output<String>? = null,
    public val connectionName: Output<String>? = null,
    public val databaseName: Output<String>,
    public val tableName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.MLTransformInputRecordTableArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.MLTransformInputRecordTableArgs =
        com.pulumi.aws.glue.inputs.MLTransformInputRecordTableArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .tableName(tableName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MLTransformInputRecordTableArgs].
 */
@PulumiTagMarker
public class MLTransformInputRecordTableArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var connectionName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value A unique identifier for the AWS Glue Data Catalog.
     */
    @JvmName("ufkfoqtvynjaefwx")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value The name of the connection to the AWS Glue Data Catalog.
     */
    @JvmName("ryteirhhuuwqprwp")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value A database name in the AWS Glue Data Catalog.
     */
    @JvmName("rxgxkfshnlutvdtv")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value A table name in the AWS Glue Data Catalog.
     */
    @JvmName("lxdvctblycfqmscw")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value A unique identifier for the AWS Glue Data Catalog.
     */
    @JvmName("ptknuvocgqifwxac")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value The name of the connection to the AWS Glue Data Catalog.
     */
    @JvmName("uhimfvopgfyasnnw")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value A database name in the AWS Glue Data Catalog.
     */
    @JvmName("mkacqwpqiqgjsgjo")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value A table name in the AWS Glue Data Catalog.
     */
    @JvmName("cmnhfvfyasdmjvfs")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): MLTransformInputRecordTableArgs = MLTransformInputRecordTableArgs(
        catalogId = catalogId,
        connectionName = connectionName,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
    )
}
