@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.MLTransformParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property findMatchesParameters The parameters for the find matches algorithm. see Find Matches Parameters.
 * @property transformType The type of machine learning transform. For information about the types of machine learning transforms, see [Creating Machine Learning Transforms](http://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html).
 */
public data class MLTransformParametersArgs(
    public val findMatchesParameters: Output<MLTransformParametersFindMatchesParametersArgs>,
    public val transformType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.MLTransformParametersArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.MLTransformParametersArgs =
        com.pulumi.aws.glue.inputs.MLTransformParametersArgs.builder()
            .findMatchesParameters(
                findMatchesParameters.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .transformType(transformType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MLTransformParametersArgs].
 */
@PulumiTagMarker
public class MLTransformParametersArgsBuilder internal constructor() {
    private var findMatchesParameters: Output<MLTransformParametersFindMatchesParametersArgs>? = null

    private var transformType: Output<String>? = null

    /**
     * @param value The parameters for the find matches algorithm. see Find Matches Parameters.
     */
    @JvmName("kgrwfommsapvoadq")
    public suspend
    fun findMatchesParameters(`value`: Output<MLTransformParametersFindMatchesParametersArgs>) {
        this.findMatchesParameters = value
    }

    /**
     * @param value The type of machine learning transform. For information about the types of machine learning transforms, see [Creating Machine Learning Transforms](http://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html).
     */
    @JvmName("xevhlmmhvjdfrutf")
    public suspend fun transformType(`value`: Output<String>) {
        this.transformType = value
    }

    /**
     * @param value The parameters for the find matches algorithm. see Find Matches Parameters.
     */
    @JvmName("kornjcomlfjfrlcv")
    public suspend
    fun findMatchesParameters(`value`: MLTransformParametersFindMatchesParametersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.findMatchesParameters = mapped
    }

    /**
     * @param argument The parameters for the find matches algorithm. see Find Matches Parameters.
     */
    @JvmName("plytfdgsoinlnkmm")
    public suspend
    fun findMatchesParameters(argument: suspend MLTransformParametersFindMatchesParametersArgsBuilder.() -> Unit) {
        val toBeMapped = MLTransformParametersFindMatchesParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.findMatchesParameters = mapped
    }

    /**
     * @param value The type of machine learning transform. For information about the types of machine learning transforms, see [Creating Machine Learning Transforms](http://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html).
     */
    @JvmName("kqisvktkpxittkpc")
    public suspend fun transformType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transformType = mapped
    }

    internal fun build(): MLTransformParametersArgs = MLTransformParametersArgs(
        findMatchesParameters = findMatchesParameters ?: throw
            PulumiNullFieldException("findMatchesParameters"),
        transformType = transformType ?: throw PulumiNullFieldException("transformType"),
    )
}
