@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSerDeInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the SerDe.
 * @property parameters A map of initialization parameters for the SerDe, in key-value form.
 * @property serializationLibrary Usually the class that implements the SerDe. An example is: org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
 */
public data class PartitionStorageDescriptorSerDeInfoArgs(
    public val name: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val serializationLibrary: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSerDeInfoArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSerDeInfoArgs =
        com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSerDeInfoArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .serializationLibrary(serializationLibrary?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartitionStorageDescriptorSerDeInfoArgs].
 */
@PulumiTagMarker
public class PartitionStorageDescriptorSerDeInfoArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var serializationLibrary: Output<String>? = null

    /**
     * @param value Name of the SerDe.
     */
    @JvmName("psxgnmrhhuulgdsr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of initialization parameters for the SerDe, in key-value form.
     */
    @JvmName("vuxhmglvxkblqnao")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Usually the class that implements the SerDe. An example is: org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
     */
    @JvmName("sbrdeasyhvfvafhw")
    public suspend fun serializationLibrary(`value`: Output<String>) {
        this.serializationLibrary = value
    }

    /**
     * @param value Name of the SerDe.
     */
    @JvmName("uwwrkxujxoksnilj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of initialization parameters for the SerDe, in key-value form.
     */
    @JvmName("grxsmaqintmaeeej")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values A map of initialization parameters for the SerDe, in key-value form.
     */
    @JvmName("ovftwbieidsiqulb")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Usually the class that implements the SerDe. An example is: org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
     */
    @JvmName("ujgnhpixelsppaps")
    public suspend fun serializationLibrary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serializationLibrary = mapped
    }

    internal fun build(): PartitionStorageDescriptorSerDeInfoArgs =
        PartitionStorageDescriptorSerDeInfoArgs(
            name = name,
            parameters = parameters,
            serializationLibrary = serializationLibrary,
        )
}
