@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSkewedInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property skewedColumnNames A list of names of columns that contain skewed values.
 * @property skewedColumnValueLocationMaps A list of values that appear so frequently as to be considered skewed.
 * @property skewedColumnValues A map of skewed values to the columns that contain them.
 */
public data class PartitionStorageDescriptorSkewedInfoArgs(
    public val skewedColumnNames: Output<List<String>>? = null,
    public val skewedColumnValueLocationMaps: Output<Map<String, String>>? = null,
    public val skewedColumnValues: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSkewedInfoArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSkewedInfoArgs =
        com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSkewedInfoArgs.builder()
            .skewedColumnNames(skewedColumnNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .skewedColumnValueLocationMaps(
                skewedColumnValueLocationMaps?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .skewedColumnValues(
                skewedColumnValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [PartitionStorageDescriptorSkewedInfoArgs].
 */
@PulumiTagMarker
public class PartitionStorageDescriptorSkewedInfoArgsBuilder internal constructor() {
    private var skewedColumnNames: Output<List<String>>? = null

    private var skewedColumnValueLocationMaps: Output<Map<String, String>>? = null

    private var skewedColumnValues: Output<List<String>>? = null

    /**
     * @param value A list of names of columns that contain skewed values.
     */
    @JvmName("pnnpdhvfcnjwxanj")
    public suspend fun skewedColumnNames(`value`: Output<List<String>>) {
        this.skewedColumnNames = value
    }

    @JvmName("yiwbbhqvamtackag")
    public suspend fun skewedColumnNames(vararg values: Output<String>) {
        this.skewedColumnNames = Output.all(values.asList())
    }

    /**
     * @param values A list of names of columns that contain skewed values.
     */
    @JvmName("xwcolwmagfrbunra")
    public suspend fun skewedColumnNames(values: List<Output<String>>) {
        this.skewedColumnNames = Output.all(values)
    }

    /**
     * @param value A list of values that appear so frequently as to be considered skewed.
     */
    @JvmName("ldvbegorbeojfgqb")
    public suspend fun skewedColumnValueLocationMaps(`value`: Output<Map<String, String>>) {
        this.skewedColumnValueLocationMaps = value
    }

    /**
     * @param value A map of skewed values to the columns that contain them.
     */
    @JvmName("fahspyaooabkxxeo")
    public suspend fun skewedColumnValues(`value`: Output<List<String>>) {
        this.skewedColumnValues = value
    }

    @JvmName("eylqunrrxjkeeckl")
    public suspend fun skewedColumnValues(vararg values: Output<String>) {
        this.skewedColumnValues = Output.all(values.asList())
    }

    /**
     * @param values A map of skewed values to the columns that contain them.
     */
    @JvmName("cgolmnlaxoryhpgr")
    public suspend fun skewedColumnValues(values: List<Output<String>>) {
        this.skewedColumnValues = Output.all(values)
    }

    /**
     * @param value A list of names of columns that contain skewed values.
     */
    @JvmName("dyxxyqhfxffdjobh")
    public suspend fun skewedColumnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skewedColumnNames = mapped
    }

    /**
     * @param values A list of names of columns that contain skewed values.
     */
    @JvmName("eyswavedtwosmkjq")
    public suspend fun skewedColumnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skewedColumnNames = mapped
    }

    /**
     * @param value A list of values that appear so frequently as to be considered skewed.
     */
    @JvmName("ukmagjnjagwlvjbe")
    public suspend fun skewedColumnValueLocationMaps(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skewedColumnValueLocationMaps = mapped
    }

    /**
     * @param values A list of values that appear so frequently as to be considered skewed.
     */
    @JvmName("tpglfvonmjepiqot")
    public fun skewedColumnValueLocationMaps(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skewedColumnValueLocationMaps = mapped
    }

    /**
     * @param value A map of skewed values to the columns that contain them.
     */
    @JvmName("uavrnkisfemxdysk")
    public suspend fun skewedColumnValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skewedColumnValues = mapped
    }

    /**
     * @param values A map of skewed values to the columns that contain them.
     */
    @JvmName("uoleucigqemykftw")
    public suspend fun skewedColumnValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skewedColumnValues = mapped
    }

    internal fun build(): PartitionStorageDescriptorSkewedInfoArgs =
        PartitionStorageDescriptorSkewedInfoArgs(
            skewedColumnNames = skewedColumnNames,
            skewedColumnValueLocationMaps = skewedColumnValueLocationMaps,
            skewedColumnValues = skewedColumnValues,
        )
}
