@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSortColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property column The name of the column.
 * @property sortOrder Indicates that the column is sorted in ascending order (== 1), or in descending order (==0).
 */
public data class PartitionStorageDescriptorSortColumnArgs(
    public val column: Output<String>,
    public val sortOrder: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSortColumnArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSortColumnArgs =
        com.pulumi.aws.glue.inputs.PartitionStorageDescriptorSortColumnArgs.builder()
            .column(column.applyValue({ args0 -> args0 }))
            .sortOrder(sortOrder.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartitionStorageDescriptorSortColumnArgs].
 */
@PulumiTagMarker
public class PartitionStorageDescriptorSortColumnArgsBuilder internal constructor() {
    private var column: Output<String>? = null

    private var sortOrder: Output<Int>? = null

    /**
     * @param value The name of the column.
     */
    @JvmName("uonnbiomhauksxvi")
    public suspend fun column(`value`: Output<String>) {
        this.column = value
    }

    /**
     * @param value Indicates that the column is sorted in ascending order (== 1), or in descending order (==0).
     */
    @JvmName("jxsdssdbnjmcoywg")
    public suspend fun sortOrder(`value`: Output<Int>) {
        this.sortOrder = value
    }

    /**
     * @param value The name of the column.
     */
    @JvmName("ymcdmyseythvjewg")
    public suspend fun column(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.column = mapped
    }

    /**
     * @param value Indicates that the column is sorted in ascending order (== 1), or in descending order (==0).
     */
    @JvmName("tjibjqotskxaydkb")
    public suspend fun sortOrder(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sortOrder = mapped
    }

    internal fun build(): PartitionStorageDescriptorSortColumnArgs =
        PartitionStorageDescriptorSortColumnArgs(
            column = column ?: throw PulumiNullFieldException("column"),
            sortOrder = sortOrder ?: throw PulumiNullFieldException("sortOrder"),
        )
}
