@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchEncryption
 * @property jobBookmarksEncryption
 * @property s3Encryption A `s3_encryption ` block as described below, which contains encryption configuration for S3 data.
 */
public data class SecurityConfigurationEncryptionConfigurationArgs(
    public val cloudwatchEncryption:
    Output<SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs>,
    public val jobBookmarksEncryption:
    Output<SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs>,
    public val s3Encryption: Output<SecurityConfigurationEncryptionConfigurationS3EncryptionArgs>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationArgs =
        com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationArgs.builder()
            .cloudwatchEncryption(
                cloudwatchEncryption.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .jobBookmarksEncryption(
                jobBookmarksEncryption.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .s3Encryption(s3Encryption.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SecurityConfigurationEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class SecurityConfigurationEncryptionConfigurationArgsBuilder internal constructor() {
    private var cloudwatchEncryption:
        Output<SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs>? = null

    private var jobBookmarksEncryption:
        Output<SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs>? = null

    private var s3Encryption: Output<SecurityConfigurationEncryptionConfigurationS3EncryptionArgs>? =
        null

    /**
     * @param value
     */
    @JvmName("ereccccawnjscqgm")
    public suspend
    fun cloudwatchEncryption(`value`: Output<SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs>) {
        this.cloudwatchEncryption = value
    }

    /**
     * @param value
     */
    @JvmName("ysrsfyeusqalidoi")
    public suspend
    fun jobBookmarksEncryption(`value`: Output<SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs>) {
        this.jobBookmarksEncryption = value
    }

    /**
     * @param value A `s3_encryption ` block as described below, which contains encryption configuration for S3 data.
     */
    @JvmName("vmgjhrbmkpmemcps")
    public suspend
    fun s3Encryption(`value`: Output<SecurityConfigurationEncryptionConfigurationS3EncryptionArgs>) {
        this.s3Encryption = value
    }

    /**
     * @param value
     */
    @JvmName("albyyvinmxjniyif")
    public suspend
    fun cloudwatchEncryption(`value`: SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchEncryption = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ydnrntoeexhghoqd")
    public suspend
    fun cloudwatchEncryption(argument: suspend SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchEncryption = mapped
    }

    /**
     * @param value
     */
    @JvmName("unnndtgajwugahio")
    public suspend
    fun jobBookmarksEncryption(`value`: SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobBookmarksEncryption = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jtnpnyrqepfpgpxb")
    public suspend
    fun jobBookmarksEncryption(argument: suspend SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jobBookmarksEncryption = mapped
    }

    /**
     * @param value A `s3_encryption ` block as described below, which contains encryption configuration for S3 data.
     */
    @JvmName("psqlnifnhkegadnm")
    public suspend
    fun s3Encryption(`value`: SecurityConfigurationEncryptionConfigurationS3EncryptionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Encryption = mapped
    }

    /**
     * @param argument A `s3_encryption ` block as described below, which contains encryption configuration for S3 data.
     */
    @JvmName("xivqkmgscntkdaes")
    public suspend
    fun s3Encryption(argument: suspend SecurityConfigurationEncryptionConfigurationS3EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            SecurityConfigurationEncryptionConfigurationS3EncryptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Encryption = mapped
    }

    internal fun build(): SecurityConfigurationEncryptionConfigurationArgs =
        SecurityConfigurationEncryptionConfigurationArgs(
            cloudwatchEncryption = cloudwatchEncryption ?: throw
                PulumiNullFieldException("cloudwatchEncryption"),
            jobBookmarksEncryption = jobBookmarksEncryption ?: throw
                PulumiNullFieldException("jobBookmarksEncryption"),
            s3Encryption = s3Encryption ?: throw PulumiNullFieldException("s3Encryption"),
        )
}
