@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyArn Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
 * @property s3EncryptionMode Encryption mode to use for S3 data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-S3`. Default value: `DISABLED`.
 */
public data class SecurityConfigurationEncryptionConfigurationS3EncryptionArgs(
    public val kmsKeyArn: Output<String>? = null,
    public val s3EncryptionMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs> {
    override fun toJava():
        com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs =
        com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs.builder()
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .s3EncryptionMode(s3EncryptionMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityConfigurationEncryptionConfigurationS3EncryptionArgs].
 */
@PulumiTagMarker
public class SecurityConfigurationEncryptionConfigurationS3EncryptionArgsBuilder internal
constructor() {
    private var kmsKeyArn: Output<String>? = null

    private var s3EncryptionMode: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     */
    @JvmName("oakbsdfcsqmftaed")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Encryption mode to use for S3 data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-S3`. Default value: `DISABLED`.
     */
    @JvmName("kfpivqvsvxloeyyg")
    public suspend fun s3EncryptionMode(`value`: Output<String>) {
        this.s3EncryptionMode = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     */
    @JvmName("hecbacpronltwmlq")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Encryption mode to use for S3 data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-S3`. Default value: `DISABLED`.
     */
    @JvmName("vobmjsdnypnhisaa")
    public suspend fun s3EncryptionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3EncryptionMode = mapped
    }

    internal fun build(): SecurityConfigurationEncryptionConfigurationS3EncryptionArgs =
        SecurityConfigurationEncryptionConfigurationS3EncryptionArgs(
            kmsKeyArn = kmsKeyArn,
            s3EncryptionMode = s3EncryptionMode,
        )
}
