@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.TriggerActionNotificationPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property notifyDelayAfter After a job run starts, the number of minutes to wait before sending a job run delay notification.
 */
public data class TriggerActionNotificationPropertyArgs(
    public val notifyDelayAfter: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.TriggerActionNotificationPropertyArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.TriggerActionNotificationPropertyArgs =
        com.pulumi.aws.glue.inputs.TriggerActionNotificationPropertyArgs.builder()
            .notifyDelayAfter(notifyDelayAfter?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerActionNotificationPropertyArgs].
 */
@PulumiTagMarker
public class TriggerActionNotificationPropertyArgsBuilder internal constructor() {
    private var notifyDelayAfter: Output<Int>? = null

    /**
     * @param value After a job run starts, the number of minutes to wait before sending a job run delay notification.
     */
    @JvmName("rqhugbuyqeqdiytw")
    public suspend fun notifyDelayAfter(`value`: Output<Int>) {
        this.notifyDelayAfter = value
    }

    /**
     * @param value After a job run starts, the number of minutes to wait before sending a job run delay notification.
     */
    @JvmName("uawlbvtukisdjsjb")
    public suspend fun notifyDelayAfter(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyDelayAfter = mapped
    }

    internal fun build(): TriggerActionNotificationPropertyArgs =
        TriggerActionNotificationPropertyArgs(
            notifyDelayAfter = notifyDelayAfter,
        )
}
