@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property permissions The permissions that are granted to the principal.
 * @property principal The principal who is granted permissions.. See `principal` below.
 */
public data class CatalogDatabaseCreateTableDefaultPermission(
    public val permissions: List<String>? = null,
    public val principal: CatalogDatabaseCreateTableDefaultPermissionPrincipal? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CatalogDatabaseCreateTableDefaultPermission):
            CatalogDatabaseCreateTableDefaultPermission = CatalogDatabaseCreateTableDefaultPermission(
            permissions = javaType.permissions().map({ args0 -> args0 }),
            principal = javaType.principal().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.CatalogDatabaseCreateTableDefaultPermissionPrincipal.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
