@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogId ID of the Data Catalog in which the database resides.
 * @property databaseName Name of the catalog database.
 * @property region Region of the target database.
 */
public data class CatalogDatabaseTargetDatabase(
    public val catalogId: String,
    public val databaseName: String,
    public val region: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CatalogDatabaseTargetDatabase):
            CatalogDatabaseTargetDatabase = CatalogDatabaseTargetDatabase(
            catalogId = javaType.catalogId(),
            databaseName = javaType.databaseName(),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
