@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property schemaId Configuration block that contains schema identity fields. Either this or the `schema_version_id` has to be provided. See `schema_id` below.
 * @property schemaVersionId Unique ID assigned to a version of the schema. Either this or the `schema_id` has to be provided.
 * @property schemaVersionNumber Version number of the schema.
 */
public data class CatalogTableStorageDescriptorSchemaReference(
    public val schemaId: CatalogTableStorageDescriptorSchemaReferenceSchemaId? = null,
    public val schemaVersionId: String? = null,
    public val schemaVersionNumber: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CatalogTableStorageDescriptorSchemaReference):
            CatalogTableStorageDescriptorSchemaReference = CatalogTableStorageDescriptorSchemaReference(
            schemaId = javaType.schemaId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.glue.kotlin.outputs.CatalogTableStorageDescriptorSchemaReferenceSchemaId.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schemaVersionId = javaType.schemaVersionId().map({ args0 -> args0 }).orElse(null),
            schemaVersionNumber = javaType.schemaVersionNumber(),
        )
    }
}
