@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property registryName Name of the schema registry that contains the schema. Must be provided when `schema_name` is specified and conflicts with `schema_arn`.
 * @property schemaArn ARN of the schema. One of `schema_arn` or `schema_name` has to be provided.
 * @property schemaName Name of the schema. One of `schema_arn` or `schema_name` has to be provided.
 */
public data class CatalogTableStorageDescriptorSchemaReferenceSchemaId(
    public val registryName: String? = null,
    public val schemaArn: String? = null,
    public val schemaName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CatalogTableStorageDescriptorSchemaReferenceSchemaId):
            CatalogTableStorageDescriptorSchemaReferenceSchemaId =
            CatalogTableStorageDescriptorSchemaReferenceSchemaId(
                registryName = javaType.registryName().map({ args0 -> args0 }).orElse(null),
                schemaArn = javaType.schemaArn().map({ args0 -> args0 }).orElse(null),
                schemaName = javaType.schemaName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
