@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowSingleColumn Enables the processing of files that contain only one column.
 * @property containsHeader Indicates whether the CSV file contains a header. This can be one of "ABSENT", "PRESENT", or "UNKNOWN".
 * @property customDatatypeConfigured Enables the custom datatype to be configured.
 * @property customDatatypes A list of supported custom datatypes. Valid values are `BINARY`, `BOOLEAN`, `DATE`, `DECIMAL`, `DOUBLE`, `FLOAT`, `INT`, `LONG`, `SHORT`, `STRING`, `TIMESTAMP`.
 * @property delimiter The delimiter used in the Csv to separate columns.
 * @property disableValueTrimming Specifies whether to trim column values.
 * @property headers A list of strings representing column names.
 * @property quoteSymbol A custom symbol to denote what combines content into a single column value. It must be different from the column delimiter.
 */
public data class ClassifierCsvClassifier(
    public val allowSingleColumn: Boolean? = null,
    public val containsHeader: String? = null,
    public val customDatatypeConfigured: Boolean? = null,
    public val customDatatypes: List<String>? = null,
    public val delimiter: String? = null,
    public val disableValueTrimming: Boolean? = null,
    public val headers: List<String>? = null,
    public val quoteSymbol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.ClassifierCsvClassifier):
            ClassifierCsvClassifier = ClassifierCsvClassifier(
            allowSingleColumn = javaType.allowSingleColumn().map({ args0 -> args0 }).orElse(null),
            containsHeader = javaType.containsHeader().map({ args0 -> args0 }).orElse(null),
            customDatatypeConfigured = javaType.customDatatypeConfigured().map({ args0 -> args0 }).orElse(null),
            customDatatypes = javaType.customDatatypes().map({ args0 -> args0 }),
            delimiter = javaType.delimiter().map({ args0 -> args0 }).orElse(null),
            disableValueTrimming = javaType.disableValueTrimming().map({ args0 -> args0 }).orElse(null),
            headers = javaType.headers().map({ args0 -> args0 }),
            quoteSymbol = javaType.quoteSymbol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
