@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionName The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
 * @property databaseName The name of the Glue database to be synchronized.
 * @property dlqEventQueueArn A valid Amazon SQS ARN.
 * > **Note:** `deletion_behavior` of catalog target doesn't support `DEPRECATE_IN_DATABASE`.
 * > **Note:** `configuration` for catalog target crawlers will have `{ ... "Grouping": { "TableGroupingPolicy": "CombineCompatibleSchemas"} }` by default.
 * @property eventQueueArn A valid Amazon SQS ARN.
 * @property tables A list of catalog tables to be synchronized.
 */
public data class CrawlerCatalogTarget(
    public val connectionName: String? = null,
    public val databaseName: String,
    public val dlqEventQueueArn: String? = null,
    public val eventQueueArn: String? = null,
    public val tables: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CrawlerCatalogTarget):
            CrawlerCatalogTarget = CrawlerCatalogTarget(
            connectionName = javaType.connectionName().map({ args0 -> args0 }).orElse(null),
            databaseName = javaType.databaseName(),
            dlqEventQueueArn = javaType.dlqEventQueueArn().map({ args0 -> args0 }).orElse(null),
            eventQueueArn = javaType.eventQueueArn().map({ args0 -> args0 }).orElse(null),
            tables = javaType.tables().map({ args0 -> args0 }),
        )
    }
}
