@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionName The name of the connection to use to connect to the Delta table target.
 * @property createNativeDeltaTable Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
 * @property deltaTables A list of the Amazon S3 paths to the Delta tables.
 * @property writeManifest Specifies whether to write the manifest files to the Delta table path.
 */
public data class CrawlerDeltaTarget(
    public val connectionName: String? = null,
    public val createNativeDeltaTable: Boolean? = null,
    public val deltaTables: List<String>,
    public val writeManifest: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CrawlerDeltaTarget):
            CrawlerDeltaTarget = CrawlerDeltaTarget(
            connectionName = javaType.connectionName().map({ args0 -> args0 }).orElse(null),
            createNativeDeltaTable = javaType.createNativeDeltaTable().map({ args0 -> args0 }).orElse(null),
            deltaTables = javaType.deltaTables().map({ args0 -> args0 }),
            writeManifest = javaType.writeManifest(),
        )
    }
}
