@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property path The name of the DynamoDB table to crawl.
 * @property scanAll Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table.  defaults to `true`.
 * @property scanRate The percentage of the configured read capacity units to use by the AWS Glue crawler. The valid values are null or a value between 0.1 to 1.5.
 */
public data class CrawlerDynamodbTarget(
    public val path: String,
    public val scanAll: Boolean? = null,
    public val scanRate: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CrawlerDynamodbTarget):
            CrawlerDynamodbTarget = CrawlerDynamodbTarget(
            path = javaType.path(),
            scanAll = javaType.scanAll().map({ args0 -> args0 }).orElse(null),
            scanRate = javaType.scanRate().map({ args0 -> args0 }).orElse(null),
        )
    }
}
