@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId Required for cross account crawls. For same account crawls as the target data, this can omitted.
 * @property useLakeFormationCredentials Specifies whether to use Lake Formation credentials for the crawler instead of the IAM role credentials.
 */
public data class CrawlerLakeFormationConfiguration(
    public val accountId: String? = null,
    public val useLakeFormationCredentials: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CrawlerLakeFormationConfiguration):
            CrawlerLakeFormationConfiguration = CrawlerLakeFormationConfiguration(
            accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
            useLakeFormationCredentials = javaType.useLakeFormationCredentials().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
