@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectionName The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
 * @property path The path of the Amazon DocumentDB or MongoDB target (database/collection).
 * @property scanAll Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
 */
public data class CrawlerMongodbTarget(
    public val connectionName: String,
    public val path: String,
    public val scanAll: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CrawlerMongodbTarget):
            CrawlerMongodbTarget = CrawlerMongodbTarget(
            connectionName = javaType.connectionName(),
            path = javaType.path(),
            scanAll = javaType.scanAll().map({ args0 -> args0 }).orElse(null),
        )
    }
}
