@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionName The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a `NETWORK` Connection type.
 * @property dlqEventQueueArn A valid Amazon SQS ARN.
 * > **Note:** `deletion_behavior` of catalog target doesn't support `DEPRECATE_IN_DATABASE`.
 * > **Note:** `configuration` for catalog target crawlers will have `{ ... "Grouping": { "TableGroupingPolicy": "CombineCompatibleSchemas"} }` by default.
 * @property eventQueueArn A valid Amazon SQS ARN.
 * @property exclusions A list of glob patterns used to exclude from the crawl.
 * @property path The name of the DynamoDB table to crawl.
 * @property sampleSize Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
 */
public data class CrawlerS3Target(
    public val connectionName: String? = null,
    public val dlqEventQueueArn: String? = null,
    public val eventQueueArn: String? = null,
    public val exclusions: List<String>? = null,
    public val path: String,
    public val sampleSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.CrawlerS3Target): CrawlerS3Target =
            CrawlerS3Target(
                connectionName = javaType.connectionName().map({ args0 -> args0 }).orElse(null),
                dlqEventQueueArn = javaType.dlqEventQueueArn().map({ args0 -> args0 }).orElse(null),
                eventQueueArn = javaType.eventQueueArn().map({ args0 -> args0 }).orElse(null),
                exclusions = javaType.exclusions().map({ args0 -> args0 }),
                path = javaType.path(),
                sampleSize = javaType.sampleSize().map({ args0 -> args0 }).orElse(null),
            )
    }
}
