@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property awsKmsKeyId A KMS key ARN that is used to encrypt the connection password. If connection password protection is enabled, the caller of CreateConnection and UpdateConnection needs at least `kms:Encrypt` permission on the specified AWS KMS key, to encrypt passwords before storing them in the Data Catalog.
 * @property returnConnectionPasswordEncrypted When set to `true`, passwords remain encrypted in the responses of GetConnection and GetConnections. This encryption takes effect independently of the catalog encryption.
 */
public data class
DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption(
    public val awsKmsKeyId: String? = null,
    public val returnConnectionPasswordEncrypted: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.glue.outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption):
            DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption =
            DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryption(
                awsKmsKeyId = javaType.awsKmsKeyId().map({ args0 -> args0 }).orElse(null),
                returnConnectionPasswordEncrypted = javaType.returnConnectionPasswordEncrypted(),
            )
    }
}
