@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogEncryptionMode The encryption-at-rest mode for encrypting Data Catalog data. Valid values are `DISABLED` and `SSE-KMS`.
 * @property sseAwsKmsKeyId The ARN of the AWS KMS key to use for encryption at rest.
 */
public data class DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest(
    public val catalogEncryptionMode: String,
    public val sseAwsKmsKeyId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.glue.outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest):
            DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest =
            DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRest(
                catalogEncryptionMode = javaType.catalogEncryptionMode(),
                sseAwsKmsKeyId = javaType.sseAwsKmsKeyId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
