@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogId The catalog id where the AWS Glue table exists.
 * @property databaseName Name of the database where the AWS Glue table exists.
 * @property tableName Name of the AWS Glue table.
 */
public data class DataQualityRulesetTargetTable(
    public val catalogId: String? = null,
    public val databaseName: String,
    public val tableName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glue.outputs.DataQualityRulesetTargetTable):
            DataQualityRulesetTargetTable = DataQualityRulesetTargetTable(
            catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
            databaseName = javaType.databaseName(),
            tableName = javaType.tableName(),
        )
    }
}
